<?php
require __DIR__ . '/db.php';
date_default_timezone_set($config['timezone']);
$deadline = strtotime($config['rate_deadline']);
$now = time();

header('Content-Type: application/json; charset=utf-8');
// Cek apakah rating sudah ditutup
if ($now > $deadline) {
    echo json_encode(['success' => false, 'message' => 'Rating sudah ditutup.']);
    exit;
}

error_reporting(1);
ini_set('display_errors', 0);

$id = isset($_POST['id']) ? (int)$_POST['id'] : 0;
$rating = isset($_POST['rating']) ? (int)$_POST['rating'] : 0;

if ($id <= 0 || $rating < 1 || $rating > 5) {
    echo json_encode(['success' => false, 'message' => 'Invalid input']);
    exit;
}

if (empty($_COOKIE['eposter_token'])) {
    $token = bin2hex(random_bytes(16));
    setcookie('eposter_token', $token, [
        'expires' => time() + (365 * 24 * 60 * 60),
        'path' => '/',
        'httponly' => true,
        'samesite' => 'Lax'
    ]);
} else {
    $token = preg_replace('/[^a-f0-9]/', '', $_COOKIE['eposter_token']);
    if ($token === '') {
        $token = bin2hex(random_bytes(16));
        setcookie('eposter_token', $token, [
            'expires' => time() + (365 * 24 * 60 * 60),
            'path' => '/',
            'httponly' => true,
            'samesite' => 'Lax'
        ]);
    }
}

$ip = $_SERVER['REMOTE_ADDR'] ?? '0.0.0.0';

try {
    $stmt = $pdo->prepare("SELECT id FROM ratings WHERE eposter_id = ? AND token = ?");
    $stmt->execute([$id, $token]);
    $existing = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($existing) {
        $update = $pdo->prepare("UPDATE ratings SET rating = ?, ip_address = ?, updated_at = NOW() WHERE id = ?");
        $update->execute([$rating, $ip, $existing['id']]);
        $message = "Ratings updated!";
    } else {
        $insert = $pdo->prepare("INSERT INTO ratings (eposter_id, rating, ip_address, token, created_at) VALUES (?, ?, ?, ?, NOW())");
        $insert->execute([$id, $rating, $ip, $token]);
        $message = "Thank you for your rating!";
    }

    $stmt = $pdo->prepare("SELECT COUNT(*) as total, ROUND(IFNULL(AVG(rating),0),1) as avg_rating FROM ratings WHERE eposter_id = ?");
    $stmt->execute([$id]);
    $stats = $stmt->fetch(PDO::FETCH_ASSOC);

    echo json_encode([
        'success' => true,
        'total' => (int)($stats['total'] ?? 0),
        'avg' => (float)($stats['avg_rating'] ?? 0),
        'message' => $message
    ]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Server error']);
}
