<?php
require __DIR__ . '/db.php';
require __DIR__ . '/functions.php';
$config = require __DIR__ . '/config.php';


if (empty($_COOKIE['eposter_token'])) {
    $token = bin2hex(random_bytes(16)); 
    setcookie('eposter_token', $token, time() + (365 * 24 * 60 * 60), '/');
} else {
    $token = $_COOKIE['eposter_token'];
}


$q = trim($_GET['q'] ?? '');
$category = trim($_GET['category'] ?? '');


$sql = "SELECT * FROM eposters WHERE 1";
$params = [];


if ($q !== '') {
    $sql .= " AND (title LIKE :q OR author LIKE :q OR category LIKE :q)";
    $params[':q'] = "%$q%";
}
if ($category !== '') {
    $sql .= " AND category = :category";
    $params[':category'] = $category;
}
$sql .= " ORDER BY id DESC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$eposters = $stmt->fetchAll();


$ipRatings = [];
$stmt = $pdo->prepare("SELECT eposter_id, rating FROM ratings WHERE token = ?");
$stmt->execute([$token]);
foreach ($stmt->fetchAll() as $r) {
    $ipRatings[$r['eposter_id']] = $r['rating'];
}


$ratingsCount = [];
$stmt = $pdo->query("SELECT eposter_id, COUNT(*) as total, AVG(rating) as avg_rating FROM ratings GROUP BY eposter_id");
foreach ($stmt->fetchAll() as $r) {
    $ratingsCount[$r['eposter_id']] = $r;
}
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Search Results - ePoster Gallery</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
<style>
:root{
  --c1:#c7cfda; --c2:#354478; --c3:#d9dad8; --c4:#8e2d2d;
}
body{
  background:var(--c1);
  color:#333;
}
.card img{
  transition:transform 0.3s;
  border-radius:10px;
}
.card-img-top {
  width: 100%;
  height: 100%;
  object-fit: cover;
}
.card:hover img{ transform:scale(1.05); }
.star{ font-size:1.3rem; color:gray; cursor:pointer; transition:0.3s; }
.star.active{ color:gold; transform:scale(1.1); }
.view-mode-icon{ cursor:pointer; font-size:1.5rem; margin:0 5px; color:var(--c2);}
.view-mode-icon.active{ color:var(--c4); }
.toast-message {
  position: fixed; top: 20px; right: -300px;
  background: #198754; color: #fff; padding: 10px 16px;
  border-radius: 8px; font-size: 0.95rem;
  box-shadow: 0 3px 10px rgba(0,0,0,0.3);
  z-index: 2000; opacity: 0;
  transition: right 0.4s ease, opacity 0.4s ease;
}
.toast-message.show { right: 20px; opacity: 1; }
.rating-count{ font-size:0.9rem; color:#555; margin-left:6px; }
.search-box{ max-width:400px; }
.list-view .card{ flex-direction:row; align-items:center;}
.list-view .card img{ width:150px; height:auto;}
.list-view .card-body{ padding-left:20px;}
</style>
</head>
<body class="p-4">
<?php include("header.php"); ?>

<div class="container">
  <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap">
    <div class="mb-2 mb-md-0">
      <h3 class="fw-bold text-dark mb-0">🔍 Search Results</h3>
      <p class="text-muted small mb-0">
        <?php if ($q || $category): ?>
          Filter:
          <?= $q ? "Keywords '<b>" . h($q) . "</b>'" : "" ?>
          <?= ($q && $category) ? " dan " : "" ?>
          <?= $category ? "Category '<b>" . h($category) . "</b>'" : "" ?>
        <?php else: ?>
          Showing all ePosters.
        <?php endif; ?>
      </p>
    </div>
  </div>

  <div id="posterContainer" class="row g-3">
    <?php if (count($eposters) > 0): ?>
      <?php foreach($eposters as $ep): 
        $avg = $ratingsCount[$ep['id']]['avg_rating'] ?? 0;
        $total = $ratingsCount[$ep['id']]['total'] ?? 0;
        $userRate = $ipRatings[$ep['id']] ?? 0;
      ?>
        <div class="col-md-4 col-sm-6 poster-item">
          <div class="card shadow-sm p-2 h-100 position-relative">
            <a href="eposter_detail.php?id=<?= $ep['id'] ?>">
              <img src="<?= h($config['base_url'].'/uploads/thumbs/'.basename($ep['thumb'])) ?>" class="card-img-top" alt="<?= h($ep['title']) ?>">
            </a>
            <div class="card-body">
              <h5><?= h($ep['title']) ?></h5>
              <p class="small text-muted mb-1"><?= ucfirst($ep['category']) ?> — <i><?= h($ep['author']) ?></i></p>

              <div class="rating mt-2">
                <?php for($i=1;$i<=5;$i++): ?>
                  <span class="star <?= $userRate >= $i ? 'active' : '' ?>" 
                        data-id="<?= $ep['id'] ?>" 
                        data-rate="<?= $i ?>">★</span>
                <?php endfor; ?>
                <span class="rating-count">(<?= $total ?>)</span>
              </div>
                <div class="position-absolute bottom-0 end-0 p-2">
                  <a href="javascript:void(0);" 
                     class="btn btn-sm btn-primary"
                     onclick="openDetailPage(<?= $ep['id'] ?>)">
                     Detail <i class="bi bi-box-arrow-up-right"></i>
                  </a>
                </div>              
            </div>
          </div>
        </div>
      <?php endforeach; ?>
    <?php else: ?>
      <div class="text-center py-5">
        <h5 class="text-muted">😢 No results found.</h5>
      </div>
    <?php endif; ?>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>

document.querySelectorAll('.star').forEach(star => {
  star.addEventListener('click', () => {
    const id = star.dataset.id;
    const rate = star.dataset.rate;
    const parent = star.parentElement;
    parent.querySelectorAll('.star').forEach(s => s.style.pointerEvents = 'none');

    fetch('rate.php', {
      method: 'POST',
      headers: {'Content-Type': 'application/x-www-form-urlencoded'},
      body: new URLSearchParams({ id: id, rating: rate })
    })
    .then(res => res.json())
    .then(data => {
      if (data.success) {
        parent.querySelectorAll('.star').forEach(s => {
          s.classList.toggle('active', parseInt(s.dataset.rate) <= rate);
        });
        parent.querySelector('.rating-count').textContent = '(' + data.total + ')';
        showToast('Thank you for your rating!', 'success');
      } else {
        showToast(data.message || 'Failed to give a rating.', 'error');
      }
    })
    .catch(() => showToast('A connection error occurred.', 'error'))
    .finally(() => parent.querySelectorAll('.star').forEach(s => s.style.pointerEvents = ''));
  });
});

// --- Toast ---
function showToast(message, type = 'success') {
  const toast = document.createElement('div');
  toast.className = `toast-message ${type}`;
  toast.textContent = message;
  document.body.appendChild(toast);
  setTimeout(() => toast.classList.add('show'), 100);
  setTimeout(() => toast.classList.remove('show'), 3000);
  setTimeout(() => toast.remove(), 3500);
}
</script>
</body>
</html>
