<?php
require __DIR__ . '/db.php';
require __DIR__ . '/functions.php';
$config = require __DIR__ . '/config.php';


if (empty($_COOKIE['eposter_token'])) {
    $token = bin2hex(random_bytes(16)); 
    setcookie('eposter_token', $token, time() + (365 * 24 * 60 * 60), '/'); // berlaku 1 tahun
} else {
    $token = $_COOKIE['eposter_token'];
}

$user_ip = $_SERVER['REMOTE_ADDR'];


//$stmt = $pdo->query("SELECT * FROM eposters ORDER BY RAND()");
$stmt = $pdo->query("SELECT * FROM eposters ORDER BY sort_order ASC");
$eposters = $stmt->fetchAll();


$ipRatings = [];
$stmt = $pdo->prepare("SELECT eposter_id, rating FROM ratings WHERE token = ?");
$stmt->execute([$token]);
foreach ($stmt->fetchAll() as $r) {
    $ipRatings[$r['eposter_id']] = $r['rating'];
}


$ratingsCount = [];
$stmt = $pdo->query("SELECT eposter_id, COUNT(*) as total, AVG(rating) as avg_rating FROM ratings GROUP BY eposter_id");
foreach ($stmt->fetchAll() as $r) {
    $ratingsCount[$r['eposter_id']] = $r;
}
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>ePoster Gallery</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
<style>
:root{
  --c1:#c7cfda; --c2:#354478; --c3:#d9dad8; --c4:#8e2d2d;
}
body{
  background:var(--c1);
  color:#333;
}
.card img{
  transition:transform 0.3s;
  border-radius:10px;
}
.card-img-top {
  width: 100%;
  height: 100%;      /* tinggi tetap sesuai desain */
  object-fit: cover;  /* crop proporsional tanpa meregang */
}
.card:hover img{ transform:scale(1.05);}
.view-mode-icon{
  cursor:pointer;
  font-size:1.5rem;
  margin:0 5px;
  color:var(--c2);
}
.view-mode-icon.active{ color:var(--c4); }
.star{
  font-size:1.3rem;
  color:gray;
  transition:transform 0.25s, color 0.25s;
  cursor:pointer;
}
.modal-content {
  border-radius: 12px;
  overflow: hidden;
}
.modal-body img {
  user-select: none;
  max-height: 90vh;
}
.card {
  position: relative;
}
.card .btn.btn-sm {
  border-radius: 20px;
  font-size: 0.85rem;
  padding: 4px 10px;
}


.toast-message {
  position: fixed;
  top: 20px;
  right: -300px;
  background: #198754;
  color: #fff;
  padding: 10px 16px;
  border-radius: 8px;
  font-size: 0.95rem;
  box-shadow: 0 3px 10px rgba(0,0,0,0.3);
  z-index: 2000;
  opacity: 0;
  transition: right 0.4s ease, opacity 0.4s ease;
}
.toast-message.info { background: #0d6efd; }
.toast-message.error { background: #dc3545; }

.toast-message.show {
  right: 20px;
  opacity: 1;
}

.star.active{ color:gold; transform:scale(1.3) rotate(-10deg);}
.star:hover{ transform:scale(1.2) rotate(-5deg); color:gold; }
.eye-icon{color:var(--c2);margin-right:5px;}
.search-box{ max-width:400px;}
.list-view .card{ flex-direction:row; align-items:center;}
.list-view .card img{ width:150px; height:auto;}
.list-view .card-body{ padding-left:20px;}
.rating-count{ font-size:0.9rem; color:#555; margin-left:6px;}
</style>
</head>
<body class="p-4">
<?php include("header.php"); ?>
<div class="container">

<div id="posterContainer" class="table-responsive list-view">
  <table class="table poster-table align-middle">
    <thead>
      <tr>
        <th class="text-center" style="width:5%">No</th>
        <th class="text-center" style="width:15%">Thumbnail</th>
        <th>Title</th>
        <th class="text-center" style="width:10%">Views</th>
        <th class="text-center" style="width:20%">Rating</th>
      </tr>
    </thead>
    <tbody>
      <?php 
      $no = 1;
      foreach($eposters as $ep): 
        $avg = $ratingsCount[$ep['id']]['avg_rating'] ?? 0;
        $total = $ratingsCount[$ep['id']]['total'] ?? 0;
        $userRate = $ipRatings[$ep['id']] ?? 0;
      ?>
      <tr class="poster-row" onclick="openDetailPage(<?= $ep['id'] ?>)">
        <td class="text-center"><?= $no++ ?></td>
        <td class="text-center">
          <img src="<?= h($config['base_url'].'/uploads/thumbs/'.basename($ep['thumb'])) ?>" 
               class="poster-thumb"
               alt="<?= h($ep['title']) ?>"
               onclick="event.stopPropagation(); openPosterModal('<?= h($config['base_url'].'/uploads/originals/'.basename($ep['filename'])) ?>', <?= $ep['id'] ?>)">
        </td>
        <td><?= h($ep['title']) ?><br/> <p class="small text-muted mb-1"><?= ucfirst($ep['category']) ?> — <i><?= h($ep['author']) ?></i></p></td>
        <td class="text-center">
          <i class="bi bi-eye text-secondary me-1"></i><?= (int)$ep['view_count'] ?>
        </td>
        <td class="text-center">
          <div class="rating">
            <?php for($i=1;$i<=5;$i++): ?>
              <span class="star <?= $userRate >= $i ? 'active' : '' ?>" 
                    data-id="<?= $ep['id'] ?>" 
                    data-rate="<?= $i ?>">★</span>
            <?php endfor; ?>
            <span class="rating-count text-muted">(<?= $total ?>)</span>
          </div>
        </td>
      </tr>
      <?php endforeach; ?>
    </tbody>
  </table>
</div>

<!-- THUMB VIEW -->
<div id="thumbContainer" class="row g-3 d-none">
  <?php foreach($eposters as $ep): 
    $avg = $ratingsCount[$ep['id']]['avg_rating'] ?? 0;
    $total = $ratingsCount[$ep['id']]['total'] ?? 0;
    $userRate = $ipRatings[$ep['id']] ?? 0;
  ?>
    <div class="col-md-4 col-sm-6 poster-item">
      <div class="card shadow-sm p-2 h-100 position-relative">
        <a href="javascript:void(0);" 
           onclick="openPosterModal('<?= h($config['base_url'].'/uploads/originals/'.basename($ep['filename'])) ?>', <?= $ep['id'] ?>)">
          <img src="<?= h($config['base_url'].'/uploads/thumbs/'.basename($ep['thumb'])) ?>" 
               class="card-img-top" 
               alt="<?= h($ep['title']) ?>">
        </a>
        <div class="card-body">
          <h5><?= h($ep['title']) ?></h5>
          <p class="small text-muted mb-1"><?= ucfirst($ep['category']) ?> — <i><?= h($ep['author']) ?></i></p>

          <div>
            <i class="bi bi-eye"></i> <?= (int)$ep['view_count'] ?> views
          </div>

          <div class="rating mt-2">
            <?php for($i=1;$i<=5;$i++): ?>
              <span class="star <?= $userRate >= $i ? 'active' : '' ?>" 
                    data-id="<?= $ep['id'] ?>" 
                    data-rate="<?= $i ?>">★</span>
            <?php endfor; ?>
            <span class="rating-count">(<?= $total ?>)</span>
          </div>
        </div>
        <div class="position-absolute bottom-0 end-0 p-2">
          <a href="javascript:void(0);" 
             class="btn btn-sm btn-primary"
             onclick="openDetailPage(<?= $ep['id'] ?>)">
             Detail <i class="bi bi-box-arrow-up-right"></i>
          </a>
        </div>
      </div>
    </div>
  <?php endforeach; ?>
</div>

</div>


<div class="modal fade" id="posterModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-dialog-centered modal-xl">
    <div class="modal-content bg-dark">
      <div class="modal-header border-0">
        <h5 class="modal-title text-light">Preview Poster</h5>
        <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body text-center p-0">
        <div class="poster-container" style="overflow:hidden; position:relative; background:#000;">
          <img id="modalPoster" src="" style="max-width:100%; transition:transform 0.2s ease; cursor:grab;">
        </div>
      </div>
      <div class="modal-footer bg-dark border-0 justify-content-center">
        <button class="btn btn-light btn-sm me-2" onclick="zoomIn()">🔍 +</button>
        <button class="btn btn-light btn-sm me-2" onclick="zoomOut()">🔍 −</button>
        <button class="btn btn-danger btn-sm" data-bs-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
function openDetailPage(id) {

  fetch('count_view.php', {
    method: 'POST',
    headers: {'Content-Type': 'application/x-www-form-urlencoded'},
    body: `id=${id}`
  })
  .then(res => res.json())
  .then(data => {
    if (data.success) {
      const el = document.getElementById(`view-count-${id}`);
      if (el) el.textContent = data.new_count;
    }
  })
  .finally(() => {
    window.location.href = `eposter_detail.php?id=${id}`;
  });
}
</script>

<script>
let zoomLevel = 1;
let isDragging = false;
let startX, startY, translateX = 0, translateY = 0;
const img = document.getElementById('modalPoster');
const modal = new bootstrap.Modal(document.getElementById('posterModal'));

function openPosterModal(src, id){
  img.src = src;
  zoomLevel = 1;
  translateX = translateY = 0;
  img.style.transform = `scale(1) translate(0px, 0px)`;
  modal.show();

    fetch('count_view.php', {
      method: 'POST',
      headers: {'Content-Type': 'application/x-www-form-urlencoded'},
      body: `id=${id}`
    })
    .then(res => res.json())
    .then(data => {
      if (data.success) {
        const viewEl = document.getElementById(`view-count-${id}`);
        if (viewEl) viewEl.textContent = data.new_count;
      }
    });
}

// Zoom in/out
function zoomIn(){ zoomLevel += 0.2; applyTransform(); }
function zoomOut(){ zoomLevel = Math.max(1, zoomLevel - 0.2); applyTransform(); }

function applyTransform(){
  img.style.transform = `scale(${zoomLevel}) translate(${translateX}px, ${translateY}px)`;
}

img.addEventListener('mousedown', (e)=>{
  if(zoomLevel > 1){
    isDragging = true;
    startX = e.clientX - translateX;
    startY = e.clientY - translateY;
    img.style.cursor = 'grabbing';
  }
});
window.addEventListener('mouseup', ()=>{
  isDragging = false;
  img.style.cursor = 'grab';
});
window.addEventListener('mousemove', (e)=>{
  if(!isDragging) return;
  translateX = e.clientX - startX;
  translateY = e.clientY - startY;
  applyTransform();
});
</script>

<script>
document.querySelectorAll('.star').forEach(star => {
  star.addEventListener('click', () => {
    const id = star.dataset.id;
    const rate = star.dataset.rate;
    const parent = star.parentElement;

    parent.querySelectorAll('.star').forEach(s => s.style.pointerEvents = 'none');

    fetch('rate.php', {
      method: 'POST',
      headers: {'Content-Type': 'application/x-www-form-urlencoded'},
      body: new URLSearchParams({ id: id, rating: rate })
    })
    .then(res => res.text())
    .then(text => {
      try {
        const data = JSON.parse(text);
        if (data.success) {
          // Update UI
          parent.querySelectorAll('.star').forEach(s => {
            s.classList.toggle('active', parseInt(s.dataset.rate) <= rate);
          });
          parent.querySelector('.rating-count').textContent = '(' + data.total + ')';

          parent.querySelectorAll('.star.active').forEach(s => {
            s.style.transform = 'scale(1.6) rotate(-10deg)';
            s.style.transition = 'transform 0.3s ease';
            setTimeout(() => { s.style.transform = 'scale(1) rotate(0)'; }, 400);
          });

          showToast(data.message || 'Thank You!', 'success');
        } else {
          showToast(data.message || 'Failed to give a rating.', 'info');
        }
      } catch (err) {
        console.error('Invalid JSON from rate.php:', text);
        showToast('Server response is invalid. Cek console (F12).', 'error');
      }
    })
    .catch(err => {
      console.error('Fetch error:', err);
      showToast('A connection error occurred.', 'error');
    })
    .finally(() => {
      // re-enable
      parent.querySelectorAll('.star').forEach(s => s.style.pointerEvents = '');
    });
  });
});


function showToast(message, type = 'success') {
  const toast = document.createElement('div');
  toast.className = `toast-message ${type}`;
  toast.textContent = message;
  document.body.appendChild(toast);

  setTimeout(() => toast.classList.add('show'), 100);
  setTimeout(() => toast.classList.remove('show'), 3000);
  setTimeout(() => toast.remove(), 3500);
}


document.getElementById('listViewBtn').addEventListener('click', () => {
  document.getElementById('posterContainer').classList.remove('d-none');
  document.getElementById('thumbContainer').classList.add('d-none');
  document.getElementById('listViewBtn').classList.add('active');
  document.getElementById('thumbViewBtn').classList.remove('active');
});

document.getElementById('thumbViewBtn').addEventListener('click', () => {
  document.getElementById('posterContainer').classList.add('d-none');
  document.getElementById('thumbContainer').classList.remove('d-none');
  document.getElementById('thumbViewBtn').classList.add('active');
  document.getElementById('listViewBtn').classList.remove('active');
});


</script>
</body>
</html>
