<!-- Header Image
<img src="https://static.wixstatic.com/media/587c50_dd296a5ebf554a2d9f0f2cbd7a18c8b5~mv2.png/v1/fill/w_1351,h_219,al_c,q_85,usm_0.66_1.00_0.01,enc_avif,quality_auto/587c50_dd296a5ebf554a2d9f0f2cbd7a18c8b5~mv2.png"
     alt="Header Banner"
     class="header-banner">
 -->
<!-- HEADER -->
<div class="header-bar" role="banner">
  <div class="header-home">
    <button class="home-btn" title="Home" onclick="window.location.href='index.php'">
      <i class="bi bi-house-door-fill"></i>
    </button>
  </div>

  <h3 class="header-title" onclick="window.location.href='index.php'">View & Rate E-Poster</h3>


</div>

<div class="container my-4">
  <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap">
    <form action="search.php" method="get" class="d-flex search-box align-items-center flex-grow-1 me-3">
      <input type="text" name="q" class="form-control me-2" placeholder="Search...">
      <select name="category" class="form-select me-2">
        <option value="">Category</option>
        <?php
        $cats = $pdo->query("SELECT DISTINCT category FROM eposters ORDER BY category ASC")->fetchAll(PDO::FETCH_COLUMN);
        foreach($cats as $cat): ?>
          <option value="<?= htmlspecialchars($cat) ?>"><?= ucfirst($cat) ?></option>
        <?php endforeach; ?>
      </select>
      <button class="btn btn-primary">Go</button>
    </form>
  </div>
</div>

<style>
/* ================= HEADER & LAYOUT ================= */
.header-banner {
  width: 100%;
  max-height: 220px;
  object-fit: cover;
  object-position: center;
  border-radius: 8px;
  display: block;
  margin-bottom: 1rem;
  background-color: #c7cfda;
}

.header-bar {
  display: flex;
  align-items: center;
  justify-content: space-between;
  background-color: #293b7b;
  color: white;
  padding: 10px 16px;
  border-radius: 8px;
  gap: 8px;
}

.header-home { width: 56px; }
.home-btn {
  background: transparent;
  border: 2px solid #fff;
  color: #fff;
  padding: 6px 8px;
  border-radius: 6px;
  font-size: 1.05rem;
  cursor: pointer;
}
.home-btn:hover { background: #fff; color: #293b7b; }

.header-title {
  margin: 0;
  font-weight: 600;
  color: #fff;
  text-align: center;
  flex: 1;
  font-size: 1.4rem;
  white-space: nowrap;
  cursor: pointer;
}

.header-controls {
  display: flex;
  gap: 8px;
  min-width: 120px;
  justify-content: flex-end;
}
.view-toggle {
  background: transparent;
  border: 2px solid #fff;
  color: #fff;
  border-radius: 6px;
  padding: 6px 10px;
  cursor: pointer;
}
.view-toggle.active { background: #fff; color: #293b7b; }

@media (max-width:768px){
  .header-bar { padding: 8px 10px; }
  .header-title { font-size: 1.05rem; white-space: normal; }
  .search-box { width: 100%; margin-top: 8px; }
  .search-box .form-control, .search-box .form-select, .search-box .btn { min-width: 0; }
}

/* ================= TABLE FIX (Zebra + Hover) ================= */

/* FIXED: gunakan spesifik selector agar override bootstrap tanpa !important */
.table.poster-table {
  border-radius: 10px;
  overflow: hidden;
  background: #fff;
  border-collapse: collapse; /* FIXED */
}

/* FIXED: pastikan warna strip terlihat di semua browser */
.table.poster-table.table-striped tbody tr:nth-of-type(odd) {
  background-color: #f8f9ff; /* soft blue tint */
}
.table.poster-table.table-striped tbody tr:nth-of-type(even) {
  background-color: #ffffff;
}

/* FIXED: hover efek kuat */
.table.poster-table.table-hover tbody tr:hover {
  background-color: #e6ecff !important;
  transition: background-color 0.2s ease;
  cursor: pointer;
}

/* header */
.table.poster-table thead.table-light th {
  background: linear-gradient(0deg, #2f4678, #293b7b);
  color: #fff;
  border-bottom: 0;
}

/* thumbnail */
.poster-thumb {
  width: 80px;
  height: 60px;
  object-fit: cover;
  border-radius: 6px;
  transition: transform .18s ease, box-shadow .18s ease;
}
.poster-thumb:hover {
  transform: scale(1.04);
  box-shadow: 0 6px 14px rgba(0,0,0,0.12);
}

/* rating */
.rating .star { color: #cfcfcf; cursor: pointer; font-size: 1.1rem; }
.rating .star.active, .rating .star:hover { color: #f4c430; }

.poster-table { box-shadow: 0 6px 18px rgba(16,40,80,0.04); }

/* FIXED: Hilangkan style lain yang bisa bentrok */
.table > tbody > tr > td {
  vertical-align: middle;
  border-color: #dee2e6;
}
</style>
