<?php
require __DIR__ . '/db.php';
require __DIR__ . '/functions.php';
$config = require __DIR__ . '/config.php';

$user_ip = $_SERVER['REMOTE_ADDR'];


if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Poster tidak ditemukan.");
}
$id = (int)$_GET['id'];


$stmt = $pdo->prepare("SELECT * FROM eposters WHERE id = ?");
$stmt->execute([$id]);
$ep = $stmt->fetch();
if (!$ep) die("Poster tidak ditemukan.");


$stmt = $pdo->prepare("UPDATE eposters SET view_count = view_count + 1 WHERE id = ?");
$stmt->execute([$id]);


$stmt = $pdo->prepare("SELECT view_count FROM eposters WHERE id = ?");
$stmt->execute([$id]);
$viewCount = (int)$stmt->fetchColumn();


$stmt = $pdo->prepare("SELECT rating FROM ratings WHERE eposter_id = ? AND ip_address = ?");
$stmt->execute([$id, $user_ip]);
$userRate = $stmt->fetchColumn() ?: 0;


$stmt = $pdo->prepare("SELECT COUNT(*) as total, AVG(rating) as avg_rating FROM ratings WHERE eposter_id = ?");
$stmt->execute([$id]);
$ratingInfo = $stmt->fetch();
$total = $ratingInfo['total'] ?? 0;
$avg = $ratingInfo['avg_rating'] ?? 0;
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Detail ePoster - <?= h($ep['title']) ?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

<style>
:root{
  --c1:#c7cfda; --c2:#354478; --c3:#d9dad8; --c4:#8e2d2d;
}
body{
  background:var(--c1);
  color:#333;
}
.poster-detail{
  display:flex;
  flex-wrap:wrap;
  align-items:flex-start;
  gap:20px;
}
.poster-detail img{
  max-width:100%;
  border-radius:10px;
  box-shadow:0 4px 12px rgba(0,0,0,0.2);
  transition:transform 0.25s;
}
.poster-detail img:hover{ transform:scale(1.02);}
.info-panel{
  flex:1;
  min-width:300px;
  background:var(--c3);
  border-radius:12px;
  padding:20px;
  box-shadow:0 2px 8px rgba(0,0,0,0.1);
}
.star{
  font-size:1.6rem;
  color:gray;
  cursor:pointer;
  transition:transform 0.2s, color 0.2s;
}
.star.active{ color:gold; transform:scale(1.2) rotate(-10deg);}
.star:hover{ color:gold; transform:scale(1.3) rotate(-5deg);}
.eye-icon{color:var(--c2); margin-right:5px;}
.btn-back{
  background:var(--c2);
  color:white;
  border:none;
}
.btn-back:hover{ background:var(--c4);}
</style>
</head>
<body class="p-4">
<?php include("header.php"); ?>
<div class="container">
  <div class="mb-5">
    <button class="btn btn-back" onclick="history.back()">
      <i class="bi bi-arrow-left"></i> Back
    </button>
  </div>

  <div class="poster-detail">
    <div class="flex-grow-1 text-center">
      <img src="<?= h($config['base_url'].'/uploads/originals/'.basename($ep['filename'])) ?>" 
           alt="<?= h($ep['title']) ?>">
    </div>

    <div class="info-panel">
      <h3 class="fw-bold"><?= h($ep['title']) ?></h3>
      <p class="small text-muted mb-1"><?= ucfirst($ep['category']) ?> — <i><?= h($ep['author']) ?></i></p>
      <div class="mb-3">
        <span class="eye-icon"><i class="bi bi-eye"></i></span>
        <span id="view-count"><?= $viewCount ?></span> views
      </div>

      <div class="rating mt-2 mb-3">
        <?php for($i=1;$i<=5;$i++): ?>
          <span class="star <?= $userRate >= $i ? 'active' : '' ?>" data-id="<?= $ep['id'] ?>" data-rate="<?= $i ?>">★</span>
        <?php endfor; ?>
        <span class="ms-2">(<?= $total ?>)</span>
      </div>

      <p><strong>Average Rating:</strong> <?= number_format($avg,1) ?>/5</p>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
// --- AJAX Rating ---
document.querySelectorAll('.star').forEach(star=>{
  star.addEventListener('click', ()=>{
    const id = star.dataset.id;
    const rate = star.dataset.rate;
    fetch('rate.php',{
      method:'POST',
      headers:{'Content-Type':'application/x-www-form-urlencoded'},
      body:`id=${id}&rating=${rate}`
    })
    .then(res=>res.json())
    .then(data=>{
      if(data.success){
        // update tampilan rating
        document.querySelectorAll('.star').forEach(s=>{
          s.classList.toggle('active', parseInt(s.dataset.rate) <= rate);
        });
      }
    });
  });
});
</script>
</body>
</html>
