<!-- HEADER -->
<header class="header-title text-center">
  <a href="index.php" class="header-link">🎨 ePoster Gallery</a>
</header>

<div class="container my-4">
  <div class="d-flex justify-content-between align-items-center mb-3 flex-wrap">
    <!-- Form Pencarian -->
    <form action="search.php" method="get" class="d-flex search-box align-items-center flex-grow-1 me-3">
      <input type="text" name="q" class="form-control me-2" placeholder="Search...">
      <select name="category" class="form-select me-2">
        <option value="">Category</option>
        <?php
        $cats = $pdo->query("SELECT DISTINCT category FROM eposters ORDER BY category ASC")
                    ->fetchAll(PDO::FETCH_COLUMN);
        foreach($cats as $cat): ?>
          <option value="<?= htmlspecialchars($cat) ?>"><?= ucfirst($cat) ?></option>
        <?php endforeach; ?>
      </select>
      <button class="btn btn-primary">Go</button>
    </form>

    <!-- Icon View Mode -->
    <div class="view-mode d-flex align-items-center">
      <i id="thumbView" class="bi bi-grid view-mode-icon" title="Thumbnail View"></i>
      <i id="listView" class="bi bi-list view-mode-icon active" title="List View"></i>
    </div>
  </div>

  <!-- LIST VIEW DEFAULT -->
  <div id="posterListView" class="poster-list">
    <?php foreach($eposters as $p): ?>
      <div class="poster-row" onclick="openDetailPage(<?= $p['id'] ?>)">
        <img src="uploads/<?= htmlspecialchars($p['thumb']) ?>" 
             alt="<?= htmlspecialchars($p['title']) ?>" 
             class="poster-thumb"
             onclick="event.stopPropagation(); openPosterModal('uploads/<?= htmlspecialchars($p['filename']) ?>')">
        <div class="poster-info">
          <h5><?= htmlspecialchars($p['title']) ?></h5>
          <p class="mb-0 text-muted"><?= htmlspecialchars($p['author']) ?> — <?= htmlspecialchars($p['category']) ?></p>
        </div>
      </div>
    <?php endforeach; ?>
  </div>
</div>
