<?php
require __DIR__ . '/db.php';
require __DIR__ . '/functions.php';
$config = require __DIR__ . '/config.php';
date_default_timezone_set($config['timezone']);

$deadline = strtotime($config['rate_deadline']);
$now = time();
$rating_closed = $now > $deadline;

$user_ip = $_SERVER['REMOTE_ADDR'];


if (!isset($_GET['id']) || !is_numeric($_GET['id'])) {
    die("Poster tidak ditemukan.");
}
$id = (int)$_GET['id'];


$stmt = $pdo->prepare("SELECT * FROM eposters WHERE id = ?");
$stmt->execute([$id]);
$ep = $stmt->fetch();
if (!$ep) die("Poster tidak ditemukan.");


$stmt = $pdo->prepare("UPDATE eposters SET view_count = view_count + 1 WHERE id = ?");
$stmt->execute([$id]);


$stmt = $pdo->prepare("SELECT view_count FROM eposters WHERE id = ?");
$stmt->execute([$id]);
$viewCount = (int)$stmt->fetchColumn();


$stmt = $pdo->prepare("SELECT rating FROM ratings WHERE eposter_id = ? AND ip_address = ?");
$stmt->execute([$id, $user_ip]);
$userRate = $stmt->fetchColumn() ?: 0;


$stmt = $pdo->prepare("SELECT COUNT(*) as total, AVG(rating) as avg_rating FROM ratings WHERE eposter_id = ?");
$stmt->execute([$id]);
$ratingInfo = $stmt->fetch();
$total = $ratingInfo['total'] ?? 0;
$avg = $ratingInfo['avg_rating'] ?? 0;
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Detail ePoster - <?= h($ep['title']) ?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">

<style>
:root {
  --c1: #c7cfda; 
  --c2: #354478; 
  --c4: #8e2d2d;
}

/* Reset & Layout */
body {
  margin: 0;
  background: var(--c1);
  color: #222;
  font-family: "Segoe UI", sans-serif;
  overflow-x: hidden;
}

/* Header (tetap bisa dipakai yang lama kalau kamu include) */
.header {
  background: var(--c2);
  color: white;
  padding: 10px 20px;
  position: fixed;
  top: 0;
  width: 100%;
  z-index: 100;
  display: flex;
  align-items: center;
  justify-content: space-between;
}
.header h4 {
  margin: 0;
  font-weight: 600;
}
.header button {
  background: transparent;
  border: none;
  color: white;
  font-size: 1.5rem;
}
.header button:hover {
  color: var(--c4);
}

/* Fullscreen Poster Container */
.poster-view {
  margin-top: 20px; /* space for header */
  display: flex;
  flex-direction: column;
  align-items: center;
  padding: 10px;
}

.poster-view img {
  width: 100%;
  max-width: 1200px;
  height: auto;
  border-radius: 10px;
  box-shadow: 0 6px 25px rgba(0,0,0,0.3);
  transition: transform 0.3s ease;
}

.poster-view img:hover {
  transform: scale(1.02);
}

/* Info section */
.info-panel {
  max-width: 1000px;
  background: white;
  margin-top: 20px;
  padding: 20px 25px;
  border-radius: 12px;
  box-shadow: 0 2px 10px rgba(0,0,0,0.1);
  align-items: center;  
}

.info-panel h3 {
  font-weight: 700;
  color: var(--c2);
}

.rating .star {
  font-size: 1.8rem;
  color: gray;
  cursor: pointer;
  transition: transform 0.2s, color 0.2s;
}

.rating .star.active {
  color: gold;
  transform: scale(1.2) rotate(-10deg);
}

.rating .star:hover {
  color: gold;
  transform: scale(1.3) rotate(-5deg);
}

.btn-back {
  background: var(--c2);
  color: white;
  border: none;
  border-radius: 8px;
  padding: 8px 16px;
}
.btn-back:hover {
  background: var(--c4);
}
</style>
</head>
<body class="p-4">
<?php include("old_header.php"); ?>
<div class="container">
  <div class="mb-4">
    <button class="btn btn-back" onclick="history.back()">
      <i class="bi bi-arrow-left"></i> Back
    </button>
  </div>

    <div class="poster-view">
      <img src="<?= h($config['base_url'].'/uploads/originals/'.basename($ep['filename'])) ?>" 
           alt="<?= h($ep['title']) ?>">
    </div>
    
    <div class="info-panel">
      <div class="d-flex justify-content-between align-items-center flex-wrap">
        <h3><?= h($ep['title']) ?></h3>
      </div>
      <p class="text-muted mb-2"><?= ucfirst($ep['category']) ?> — <i><?= h($ep['author']) ?></i></p>
    
      <div class="mb-3">
        <i class="bi bi-eye text-secondary me-1"></i><?= $viewCount ?> views
      </div>
    
      <div class="rating mb-3">
        <?php for($i=1;$i<=5;$i++): ?>
          <span class="star <?= $userRate >= $i ? 'active' : '' ?>" 
                data-id="<?= $ep['id'] ?>" data-rate="<?= $i ?>">★</span>
        <?php endfor; ?>
        <span class="ms-2">(<?= $total ?>)</span>
      </div>
    
      <p><strong>Average Rating:</strong> <?= number_format($avg,1) ?>/5</p>
      <p id="ratingMessage" class="text-center mt-2 text-warning fw-semibold"></p>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
// --- AJAX Rating ---
document.addEventListener('DOMContentLoaded', function() {
  const ratingClosed = <?= $rating_closed ? 'true' : 'false' ?>;

  if (ratingClosed) {
    document.getElementById('ratingMessage').innerText = '⭐ Rating is closed.';
    document.querySelectorAll('.rating .star').forEach(star => {
      star.style.opacity = '0.5';
      star.style.pointerEvents = 'none';
    });
    return; // Stop rating interaction
  }

  // Jika rating masih aktif
  document.querySelectorAll('.rating .star').forEach(star => {
    star.addEventListener('mouseenter', e => {
      const rate = parseInt(star.dataset.rate);
      document.querySelectorAll('.rating .star').forEach(s => {
        s.classList.toggle('active', parseInt(s.dataset.rate) <= rate);
      });
    });

    star.addEventListener('mouseleave', () => {
      document.querySelectorAll('.rating .star').forEach(s => s.classList.remove('active'));
    });

    star.addEventListener('click', e => {
      const rate = star.dataset.rate;
      const id = document.querySelector('.rating').dataset.id;

      fetch('rate.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: `id=${id}&rating=${rate}`
      })
      .then(res => res.json())
      .then(data => {
        const msg = document.getElementById('ratingMessage');
        msg.innerText = data.message;
        msg.style.color = data.success ? 'limegreen' : 'red';
      });
    });
  });
});

const ratingClosed = <?= $rating_closed ? 'true' : 'false' ?>;

if (ratingClosed) {
  document.getElementById('ratingMessage').innerText = '⭐ RRating is closed';
  document.querySelectorAll('.rating .star').forEach(star => {
    star.style.opacity = '0.5';
    star.style.pointerEvents = 'none';
  });
} else {
  // Aktifkan rating interaktif hanya jika belum ditutup
  document.querySelectorAll('.rating .star').forEach(star => {
    star.addEventListener('mouseenter', e => {
      const rate = parseInt(star.dataset.rate);
      document.querySelectorAll('.rating .star').forEach(s => {
        s.classList.toggle('active', parseInt(s.dataset.rate) <= rate);
      });
    });

    star.addEventListener('mouseleave', () => {
      document.querySelectorAll('.rating .star').forEach(s => s.classList.remove('active'));
    });

    star.addEventListener('click', e => {
      const rate = star.dataset.rate;
      const id = <?= $ep['id'] ?>;

      fetch('rate.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: `id=${id}&rating=${rate}`
      })
      .then(res => res.json())
      .then(data => {
        const msg = document.getElementById('ratingMessage');
        msg.innerText = data.message;
        msg.style.color = data.success ? 'limegreen' : 'red';
      });
    });
  });
}

</script>
</body>
</html>
