<?php
session_start();
require_once "../config.php";

if (!isset($_SESSION['admin_logged_in'])) {
    header("Location: login.php");
    exit();
}

$stmt = $pdo->query("SELECT * FROM eposters ORDER BY id DESC");
$eposters = $stmt->fetchAll(PDO::FETCH_ASSOC);

function getRatingBreakdown($pdo, $poster_id) {
    $stmt = $pdo->prepare("
        SELECT rating_value, COUNT(*) AS total 
        FROM ratings 
        WHERE poster_id = ? 
        GROUP BY rating_value 
        ORDER BY rating_value DESC
    ");
    $stmt->execute([$poster_id]);
    $rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

    $breakdown = [5 => 0, 4 => 0, 3 => 0, 2 => 0, 1 => 0];
    foreach ($rows as $r) {
        $breakdown[$r['rating_value']] = $r['total'];
    }
    return $breakdown;
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="UTF-8">
<title>Daftar ePoster - Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css">
<style>
body {
    background-color: #c7cfda;
    color: #354478;
}
.card {
    border-radius: 12px;
    box-shadow: 0 3px 8px rgba(0,0,0,0.2);
    transition: transform 0.2s;
}
.card:hover {
    transform: scale(1.02);
}
.rating-bar {
    height: 10px;
    background-color: #8e2d2d;
    border-radius: 5px;
}
.table th {
    background-color: #354478;
    color: #fff;
}
.badge-cat {
    background-color: #8e2d2d;
}
</style>
</head>
<body class="p-4">
<div class="container">
    <h2 class="mb-4">📊 Daftar ePoster & Rating Breakdown</h2>
    <a href="dashboard.php" class="btn btn-secondary mb-3"><i class="bi bi-arrow-left"></i> Kembali</a>
    <table class="table table-bordered table-striped align-middle">
        <thead>
            <tr>
                <th>#</th>
                <th>Thumbnail</th>
                <th>Judul</th>
                <th>Kategori</th>
                <th>Views</th>
                <th>Rating Breakdown</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($eposters as $i => $p): 
            $breakdown = getRatingBreakdown($pdo, $p['id']);
            $totalRatings = array_sum($breakdown);
            $avg = 0;
            if ($totalRatings > 0) {
                $sum = 0;
                foreach ($breakdown as $star => $count) {
                    $sum += $star * $count;
                }
                $avg = round($sum / $totalRatings, 1);
            }
        ?>
            <tr>
                <td><?= $i+1 ?></td>
                <td>
                    <img src="../<?= htmlspecialchars($p['thumbnail_path']) ?>" width="80" class="rounded">
                </td>
                <td><?= htmlspecialchars($p['title']) ?></td>
                <td><span class="badge badge-cat"><?= htmlspecialchars($p['category']) ?></span></td>
                <td><i class="bi bi-eye"></i> <?= $p['views'] ?></td>
                <td>
                    <div class="fw-bold">Rata-rata: <?= $avg ?> ⭐ (<?= $totalRatings ?> penilai)</div>
                    <?php foreach (array_reverse(range(1,5)) as $star): ?>
                        <div class="d-flex align-items-center mt-1">
                            <span style="width:40px;"><?= $star ?>⭐</span>
                            <div class="flex-grow-1 mx-2">
                                <div class="rating-bar" style="width:<?= $totalRatings ? ($breakdown[$star]/$totalRatings)*100 : 0 ?>%;"></div>
                            </div>
                            <span><?= $breakdown[$star] ?></span>
                        </div>
                    <?php endforeach; ?>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
    </table>
</div>
</body>
</html>
