<?php
require __DIR__ . '/../db.php';
require __DIR__ . '/../functions.php';
$config = require __DIR__ . '/../config.php';

$id = (int)($_GET['id'] ?? 0);
$stmt = $pdo->prepare("SELECT * FROM eposters WHERE id=?");
$stmt->execute([$id]);
$ep = $stmt->fetch();

if(!$ep) die("Poster tidak ditemukan.");

// tambah view
$pdo->prepare("UPDATE eposters SET view_count=view_count+1 WHERE id=?")->execute([$id]);

$stmt = $pdo->prepare("SELECT COUNT(*) as total, AVG(rating) as avg_rating FROM ratings WHERE eposter_id=?");
$stmt->execute([$id]);
$ratingInfo = $stmt->fetch();
$total = $ratingInfo['total'] ?? 0;
$avg = $ratingInfo['avg_rating'] ?? 0;
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title><?= h($ep['title']) ?> - Display View</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<link href="style.css" rel="stylesheet">
</head>
<body>
<?php include "header.php"; ?>

<div class="poster-display text-center py-4">
  <img src="<?= h($config['base_url'].'/uploads/originals/'.basename($ep['filename'])) ?>" class="poster-full" alt="<?= h($ep['title']) ?>">
</div>

<div class="info-panel mx-auto mt-3 p-3 bg-white rounded shadow-sm" style="max-width:1000px;">
  <h3 class="fw-bold mb-1"><?= h($ep['title']) ?></h3>
  <p class="text-muted"><?= ucfirst($ep['category']) ?> — <i><?= h($ep['author']) ?></i></p>
  <p><i class="bi bi-eye text-secondary me-1"></i><?= $ep['view_count'] ?> views</p>

  <div class="rating">
    <?php for($i=1;$i<=5;$i++): ?>
      <span class="star <?= round($avg) >= $i ? 'active' : '' ?>" data-id="<?= $ep['id'] ?>" data-rate="<?= $i ?>">★</span>
    <?php endfor; ?>
    <span class="ms-2">(<?= $total ?>)</span>
  </div>
</div>

<script>
// Rating bebas tanpa batas cookie
document.querySelectorAll('.star').forEach(star=>{
  star.addEventListener('click', ()=>{
    const id = star.dataset.id;
    const rate = star.dataset.rate;
    fetch('rate.php',{
      method:'POST',
      headers:{'Content-Type':'application/x-www-form-urlencoded'},
      body:`id=${id}&rating=${rate}`
    }).then(r=>r.json()).then(d=>{
      if(d.success){
        document.querySelectorAll('.star').forEach(s=>{
          s.classList.toggle('active', parseInt(s.dataset.rate) <= rate);
        });
      }
    });
  });
});
</script>
</body>
</html>
