<?php
require __DIR__ . '/../db.php';
require __DIR__ . '/../functions.php';
$config = require __DIR__ . '/../config.php';

$q = $_GET['q'] ?? '';
$category = $_GET['category'] ?? '';

$sql = "SELECT * FROM eposters WHERE 1";
$params = [];

if ($q) {
  $sql .= " AND (title LIKE ? OR author LIKE ?)";
  $params[] = "%$q%";
  $params[] = "%$q%";
}
if ($category) {
  $sql .= " AND category = ?";
  $params[] = $category;
}

$sql .= " ORDER BY sort_order ASC";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$eposters = $stmt->fetchAll();

if (!$eposters) {
  echo "<div class='col-12 text-center text-muted py-5'>Tidak ada hasil ditemukan.</div>";
  exit;
}

foreach ($eposters as $ep): ?>
  <div class="col-md-4 col-sm-6">
    <div class="card shadow-sm p-2 h-100">
      <a href="detail.php?id=<?= $ep['id'] ?>">
        <img src="<?= $config['base_url'].'/uploads/thumbs/'.basename($ep['thumb']) ?>" 
             class="card-img-top" alt="<?= htmlspecialchars($ep['title']) ?>">
      </a>
      <div class="card-body">
        <h5 class="mb-1"><?= htmlspecialchars($ep['title']) ?></h5>
        <p class="small text-muted"><?= ucfirst($ep['category']) ?> — <i><?= htmlspecialchars($ep['author']) ?></i></p>
        <div><i class="bi bi-eye"></i> <?= (int)$ep['view_count'] ?> views</div>
        <div class="mt-2">
          <?php 
            $avg = $ep['avg_rating'] ?? 0;
            for($i=1; $i<=5; $i++): 
          ?>
            <span class="star <?= $i <= round($avg) ? 'active' : '' ?>">★</span>
          <?php endfor; ?>
        </div>
      </div>
    </div>
  </div>
<?php endforeach; ?>
