<?php
require __DIR__ . '/../db.php';
require __DIR__ . '/../functions.php';
$config = require __DIR__ . '/../config.php';

$q = trim($_GET['q'] ?? '');
$category = trim($_GET['category'] ?? '');

$where = [];
$params = [];
if ($q) { $where[] = "(title LIKE :q OR author LIKE :q)"; $params[':q'] = "%$q%"; }
if ($category) { $where[] = "category = :c"; $params[':c'] = $category; }
$whereSQL = $where ? "WHERE ".implode(" AND ", $where) : "";

$stmt = $pdo->prepare("SELECT * FROM eposters $whereSQL ORDER BY sort_order ASC");
$stmt->execute($params);
$eposters = $stmt->fetchAll();

$ratingsStmt = $pdo->query("SELECT eposter_id, AVG(rating) as avg_rating, COUNT(*) as total FROM ratings GROUP BY eposter_id");
$ratingsCount = [];
foreach ($ratingsStmt as $r) {
  $ratingsCount[$r['eposter_id']] = ['avg_rating'=>$r['avg_rating'],'total'=>$r['total']];
}

if (!$eposters) {
  echo "<div class='col-12 text-center text-muted py-5'>❌ no results found</div>";  exit;
}

foreach($eposters as $ep):
  $avg = $ratingsCount[$ep['id']]['avg_rating'] ?? 0;
  $total = $ratingsCount[$ep['id']]['total'] ?? 0;
?>
<div class="col-md-4 col-sm-6 poster-item" data-category="<?= htmlspecialchars($ep['category']) ?>">
  <div class="card shadow-sm border-0 poster-card" data-id="<?= $ep['id'] ?>">
    <img src="<?= h($config['base_url'].'/uploads/thumbs/'.basename($ep['thumb'])) ?>" class="card-img-top" alt="<?= h($ep['title']) ?>">
    <div class="card-body text-center">
      <h5 class="fw-bold"><?= h($ep['title']) ?></h5>
      <p class="text-muted small mb-2"><?= ucfirst($ep['category']) ?> — <i><?= h($ep['author']) ?></i></p>
      <div><i class="bi bi-eye text-secondary me-1"></i><?= (int)$ep['view_count'] ?> views</div>
      <div class="rating mt-2" data-id="<?= $ep['id'] ?>">
        <?php for($i=1;$i<=5;$i++): ?>
          <span class="star <?= $avg >= $i ? 'active' : '' ?>" data-rate="<?= $i ?>">★</span>
        <?php endfor; ?>
        <span class="ms-1 text-muted small">(<?= $total ?>)</span>
      </div>
    </div>
  </div>
</div>

<?php endforeach; ?>
