<?php
require __DIR__ . '/db.php';
$config = require __DIR__ . '/config.php';
date_default_timezone_set($config['timezone']);

// Ambil batas waktu rate
$deadline = strtotime($config['rate_deadline']);
$now = time();

// Cek apakah rating sudah ditutup
if ($now > $deadline) {
  echo json_encode(['success' => false, 'message' => 'Rating sudah ditutup.']);
  exit;
}

// Jika masih aktif, lanjutkan proses
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $id = intval($_POST['id'] ?? 0);
  $rating = intval($_POST['rating'] ?? 0);

  if ($id > 0 && $rating >= 1 && $rating <= 5) {
    // Insert baru setiap kali rate (tanpa update)
    $stmt = $pdo->prepare("INSERT INTO ratings (eposter_id, rating, created_at) VALUES (?, ?, NOW())");
    $stmt->execute([$id, $rating]);
    echo json_encode(['success' => true, 'message' => 'Terima kasih, rating Anda berhasil disimpan!']);
  } else {
    echo json_encode(['success' => false, 'message' => 'Data tidak valid.']);
  }
} else {
  echo json_encode(['success' => false, 'message' => 'Metode tidak diizinkan.']);
}
