<?php
require __DIR__ . '/../db.php';
require __DIR__ . '/../functions.php';
$config = require __DIR__ . '/../config.php';

// Ambil kategori unik
$catStmt = $pdo->query("SELECT DISTINCT category FROM eposters ORDER BY category ASC");
$categories = $catStmt->fetchAll(PDO::FETCH_COLUMN);

// Ambil semua ePoster
$stmt = $pdo->query("SELECT * FROM eposters ORDER BY sort_order ASC");
$eposters = $stmt->fetchAll();

// Ambil rating rata-rata
$ratingsStmt = $pdo->query("SELECT eposter_id, AVG(rating) as avg_rating, COUNT(*) as total FROM ratings GROUP BY eposter_id");
$ratingsCount = [];
foreach ($ratingsStmt as $r) {
  $ratingsCount[$r['eposter_id']] = ['avg_rating'=>$r['avg_rating'],'total'=>$r['total']];
}

$q = $_GET['q'] ?? '';
$category = $_GET['category'] ?? '';

$sql = "SELECT * FROM eposters WHERE 1";
$params = [];

if ($q) {
  $sql .= " AND (title LIKE ? OR author LIKE ?)";
  $params[] = "%$q%";
  $params[] = "%$q%";
}
if ($category) {
  $sql .= " AND category = ?";
  $params[] = $category;
}

$sql .= " ORDER BY sort_order ASC";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$eposters = $stmt->fetchAll();

?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Display ePoster Interactive</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<link href="style.css" rel="stylesheet">
</head>
<body>
<?php include "header2.php"; ?>
<div class="container py-2" style="margin-top: 0px;">
   <!-- GRID POSTER -->
  <div class="row g-4" id="posterContainer">
    <?php foreach($eposters as $ep): 
      $avg = $ratingsCount[$ep['id']]['avg_rating'] ?? 0;
      $total = $ratingsCount[$ep['id']]['total'] ?? 0;
    ?>
    <div class="col-md-4 col-sm-6 poster-item" data-category="<?= htmlspecialchars($ep['category']) ?>">
      <div class="card shadow-sm border-0 poster-card" data-id="<?= $ep['id'] ?>">
        <img src="<?= h($config['base_url'].'/uploads/thumbs/'.basename($ep['thumb'])) ?>" class="card-img-top" alt="<?= h($ep['title']) ?>">
        <div class="card-body text-center">
          <h5 class="fw-bold"><?= h($ep['title']) ?></h5>
          <p class="text-muted small mb-2"><?= ucfirst($ep['category']) ?> — <i><?= h($ep['author']) ?></i></p>
          <div>
            <i class="bi bi-eye text-secondary me-1"></i><?= (int)$ep['view_count'] ?> views
          </div>
            <div class="rating" data-id="<?= $ep['id'] ?>">
              <?php 
                // bulatkan rata-rata rating
                $avg = $ratingsCount[$ep['id']]['avg_rating'] ?? 0;
                $avg_rounded = round($avg);
            
                for ($i = 1; $i <= 5; $i++): 
              ?>
                <span class="star <?= ($i <= $avg_rounded) ? 'active' : '' ?>">★</span>
              <?php endfor; ?>
              <span class="rating-count text-muted ms-1">(<?= $ratingsCount[$ep['id']]['total'] ?? 0 ?>)</span>
            </div>
        </div>
      </div>
    </div>
    <?php endforeach; ?>
  </div>
</div>

<script>
// === NAVIGATE TO DETAIL ===
document.querySelectorAll('.poster-card').forEach(card=>{
  card.addEventListener('click', ()=>{
    const id = card.dataset.id;
    window.location.href = `detail.php?id=${id}`;
  });
});

// === AJAX RATING ===
function bindPosterEvents() {
  // === Klik ke halaman detail ===
  document.querySelectorAll('.poster-card').forEach(card=>{
    card.addEventListener('click', ()=>{
      const id = card.dataset.id;
      window.location.href = `detail.php?id=${id}`;
    });
  });

  // === Rating interaktif ===
if (document.body.classList.contains('detail-page')) {  
  document.querySelectorAll('.star').forEach(star=>{
    star.addEventListener('click', e=>{
      e.stopPropagation();
      const rate = star.dataset.rate;
      const wrapper = star.closest('.rating');
      const id = wrapper.dataset.id;
      star.classList.add('pulse');

      fetch('rate.php', {
        method:'POST',
        headers:{'Content-Type':'application/x-www-form-urlencoded'},
        body:`id=${id}&rating=${rate}`
      })
      .then(res=>res.json())
      .then(data=>{
        if(data.success){
          wrapper.querySelectorAll('.star').forEach(s=>{
            s.classList.toggle('active', parseInt(s.dataset.rate) <= rate);
          });
        }
        star.classList.remove('pulse');
      });
    });
  });
}
}


// === NAVIGATE TO DETAIL ===
document.querySelectorAll('.poster-card').forEach(card => {
  card.addEventListener('click', () => {
    const id = card.dataset.id;
    window.location.href = `detail.php?id=${id}`;
  });
});

// === LIVE SEARCH + FILTER ===
// === Search + Filter ===
function fetchResults(){
  const q = document.getElementById('searchInput').value.trim();
  const cat = document.getElementById('categorySelect').value;
  fetch(`search.php?q=${encodeURIComponent(q)}&category=${encodeURIComponent(cat)}`)
    .then(res => res.text())
    .then(html => {
      document.getElementById('posterContainer').innerHTML = html;
      bindPosterEvents(); // ⬅️ re-bind event setelah hasil AJAX masuk
    });
}

document.getElementById('searchInput').addEventListener('keyup', fetchResults);
document.getElementById('categorySelect').addEventListener('change', fetchResults);

// Bind pertama kali
bindPosterEvents();
</script>
</body>
</html>
