<!-- display_header.php -->
<header class="display-header shadow-sm">
  <div class="container py-3 d-flex flex-wrap justify-content-between align-items-center">
    <h2 class="fw-bold mb-2 mb-sm-0" style="color:#354478; cursor:pointer;" onclick="window.location.href='index.php'">
      🩺 View & Rate E-Poster
    </h2>

   <form action="index.php" method="get" class="d-flex flex-wrap align-items-center gap-2" style="max-width: 700px; width: 100%;">
      <input type="text" id="searchInput" class="form-control" placeholder="Search..." name="q" style="flex: 1;">
      <select id="categorySelect" class="form-select" name="category" style="width: 180px;">
        <option value="">Category</option>
        <option value="surgical">Surgical</option>
        <option value="pulmonology">Pulmonology</option>
        <option value="oncology">Oncology</option>
      </select>
      <button type="submit" class="btn btn-primary">
        <i class="bi bi-search"></i>
      </button>
    </form>
  </div>
</header>

<style>
.display-header {
  position: sticky;
  top: 0;
  z-index: 1050;
  background: #f9fafc;
  border-bottom: 2px solid #35447825;
}
.display-header input, 
.display-header select {
  border-radius: 8px;
}
</style>

<script>
// 🔍 fungsi search global (tanpa reload)
document.getElementById('searchForm').addEventListener('submit', function(e){
  e.preventDefault();
  const q = document.getElementById('searchInput').value.trim();
  const category = document.getElementById('categorySelect').value;

  if(window.location.pathname.includes('detail.php')) {
    window.location.href = `index.php?q=${encodeURIComponent(q)}&category=${encodeURIComponent(category)}`;
  } else {
    fetch(`search_display.php?q=${encodeURIComponent(q)}&category=${encodeURIComponent(category)}`)
    .then(res => res.text())
    .then(html => {
      document.getElementById('posterGrid').innerHTML = html;
    });
  }
});
</script>
