<?php
require __DIR__ . '/../db.php';
require __DIR__ . '/../functions.php';
$config = require __DIR__ . '/../config.php';

$id = $_GET['id'] ?? 0;
$stmt = $pdo->prepare("SELECT * FROM eposters WHERE id = ?");
$stmt->execute([$id]);
$ep = $stmt->fetch();
if (!$ep) die("Poster not found.");

$pdo->prepare("UPDATE eposters SET view_count = view_count + 1 WHERE id = ?")->execute([$id]);
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title><?= htmlspecialchars($ep['title']) ?> - Detail</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<style>
<!-- CSS tambahan / ganti di <style> -->
<style>
body{
  background:#c7cfda;
  padding-top:80px;
  color:#222;
}

.poster-full {
  max-width:90%;
  border-radius:10px;
  box-shadow:0 6px 18px rgba(0,0,0,0.3);
}

/* === RATING AREA STYLING === */
.rating-wrapper {
  background:rgba(255,255,255,0.8);
  border:2px solid #e5e7eb;
  border-radius:12px;
  display:inline-block;
  padding:15px 25px;
  margin-top:20px;
  box-shadow:0 4px 12px rgba(0,0,0,0.1);
}

.star {
  font-size:2.5rem;
  color:#d1d5db; /* default abu */
  cursor:pointer;
  transition:all .2s ease-in-out;
  margin:0 5px;
}

.star:hover {
  color:#facc15; /* gold */
  transform:scale(1.3) rotate(-5deg);
  text-shadow:0 0 10px rgba(250,204,21,0.6);
}

.btn-back {
  background:#1e3a8a;
  color:#fff;
  border:none;
  border-radius:8px;
  padding:8px 14px;
}
.btn-back:hover {
  background:#b91c1c;
}

.alert-box{
  position:fixed;
  top:20px;
  right:20px;
  background:#16a34a;
  color:#fff;
  padding:10px 16px;
  border-radius:8px;
  display:none;
  z-index:9999;
}
.rating {
  display: inline-flex;
  align-items: center;
  gap: 4px;
}

.star {
  font-size: 2rem;
  color: #ccc;
  cursor: pointer;
  transition: transform 0.25s ease, color 0.25s ease, text-shadow 0.25s ease;
}

.star.active {
  color: gold;
  text-shadow: 0 0 10px rgba(255, 215, 0, 0.6);
  transform: scale(1.2);
}

.star.bounce {
  animation: bounceStar 0.4s ease;
}

@keyframes bounceStar {
  0% { transform: scale(1.2); }
  50% { transform: scale(1.4); }
  100% { transform: scale(1); }
}

/* area rating agar kontras */
.rating-box {
  background: rgba(255, 255, 255, 0.8);
  border-radius: 10px;
  padding: 12px 18px;
  display: inline-block;
  box-shadow: 0 2px 10px rgba(0,0,0,0.15);
}

</style>

</style>
</head>
<body>

<?php include("display_header.php"); ?>
<div id="alert" class="alert-box"></div>

<div class="container-fluid text-center">
  <div class="my-3">
    <button class="btn btn-back" onclick="history.back()">
      <i class="bi bi-arrow-left"></i> Back
    </button>
  </div>

  <img src="<?= $config['base_url'].'/uploads/originals/'.basename($ep['filename']) ?>"
       class="poster-full img-fluid" alt="<?= htmlspecialchars($ep['title']) ?>">

  <h4 class="fw-bold mt-4"><?= htmlspecialchars($ep['title']) ?></h4>
  <p class="text-muted"><?= ucfirst($ep['category']) ?> — <?= htmlspecialchars($ep['author']) ?></p>
  <p><i class="bi bi-eye"></i> <?= $ep['view_count'] + 1 ?> views</p>

  <!-- Rating kosong tapi aktif -->
<!-- Rating Area -->
<div class="rating-box mt-3">
  <div class="rating mt-2 mb-3">
    <?php for($i=1;$i<=5;$i++): ?>
      <span class="star <?= $userRate >= $i ? 'active' : '' ?>" 
            data-id="<?= $ep['id'] ?>" 
            data-rate="<?= $i ?>">★</span>
    <?php endfor; ?>
  </div>
  <div class="small text-muted mt-1">
    Average: <?= number_format($avg,1) ?>/5 (<?= $total ?> votes)
  </div>
</div>



  <div class="my-4">
    <button class="btn btn-back" onclick="history.back()">
      <i class="bi bi-arrow-left"></i> Back
    </button>
  </div>
</div>

<script>
function showAlert(msg){
  const a=document.getElementById('alert');
  a.textContent=msg; a.style.display='block';
  setTimeout(()=>a.style.display='none',2000);
}
document.querySelectorAll('.star').forEach(s=>{
  s.addEventListener('click',()=>{
    const id=document.querySelector('.rating').dataset.id;
    const rate=s.dataset.rate;
    fetch('rate.php',{method:'POST',headers:{'Content-Type':'application/x-www-form-urlencoded'},body:`id=${id}&rating=${rate}`})
    .then(r=>r.json()).then(d=>{
      if(d.success){
        s.style.color='gold';
        showAlert('Thank you, your rating is saved.!');
      } else showAlert('Failed to save rating');
    });
  });
});

document.querySelectorAll('.star').forEach(star => {
  star.addEventListener('click', () => {
    const rate = parseInt(star.dataset.rate);
    const id = star.dataset.id;
    const stars = star.parentElement.querySelectorAll('.star');

    // animasi wave effect
    stars.forEach((s, i) => {
      s.classList.toggle('active', i < rate);
      s.classList.remove('bounce');
      if (i < rate) {
        setTimeout(() => s.classList.add('bounce'), i * 80);
      }
    });

    // kirim rating via AJAX
    fetch('rate.php', {
      method: 'POST',
      headers: {'Content-Type': 'application/x-www-form-urlencoded'},
      body: `id=${id}&rating=${rate}`
    })
    .then(res => res.json())
    .then(data => {
      if (data.success) {
        showToast('Thank you! Your rating has been saved.', 'success');
      } else {
        showToast('Failed to save rating.', 'error');
      }
    })
    .catch(() => showToast('A connection error occurred.', 'error'));
  });
});

// fungsi toast notifikasi
function showToast(message, type='success') {
  const toast = document.createElement('div');
  toast.textContent = message;
  toast.className = `toast-message ${type}`;
  document.body.appendChild(toast);
  setTimeout(() => toast.classList.add('show'), 100);
  setTimeout(() => toast.classList.remove('show'), 3000);
  setTimeout(() => toast.remove(), 3500);
}

// styling toast
const style = document.createElement('style');
style.innerHTML = `
.toast-message {
  position: fixed;
  top: 20px;
  right: -300px;
  background: #198754;
  color: white;
  padding: 10px 16px;
  border-radius: 8px;
  box-shadow: 0 3px 10px rgba(0,0,0,0.3);
  z-index: 9999;
  opacity: 0;
  transition: right 0.4s ease, opacity 0.4s ease;
}
.toast-message.error { background: #dc3545; }
.toast-message.show {
  right: 20px;
  opacity: 1;
}`;
document.head.appendChild(style);
</script>
</body>
</html>
