<?php
require __DIR__ . '/../db.php';
require __DIR__ . '/../functions.php';
$config = require __DIR__ . '/../config.php';
date_default_timezone_set($config['timezone']);

$deadline = strtotime($config['rate_deadline']);
$now = time();
$rating_closed = $now > $deadline;

$id = $_GET['id'] ?? 0;
$stmt = $pdo->prepare("SELECT * FROM eposters WHERE id = ?");
$stmt->execute([$id]);
$ep = $stmt->fetch();
if (!$ep) die("Poster not found.");

$pdo->prepare("UPDATE eposters SET view_count = view_count + 1 WHERE id = ?")->execute([$id]);
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title><?= htmlspecialchars($ep['title']) ?> - Detail</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<style>
<!-- CSS tambahan / ganti di <style> -->
<style>
body{
  background:#c7cfda;
  padding-top:80px;
  color:#222;
}

.poster-full {
  max-width:90%;
  border-radius:10px;
  box-shadow:0 6px 18px rgba(0,0,0,0.3);
}

/* === RATING AREA STYLING === */
.rating-wrapper {
  background:rgba(255,255,255,0.8);
  border:2px solid #e5e7eb;
  border-radius:12px;
  display:inline-block;
  padding:15px 25px;
  margin-top:20px;
  box-shadow:0 4px 12px rgba(0,0,0,0.1);
}

.star {
  font-size:2.5rem;
  color:#d1d5db; /* default abu */
  cursor:pointer;
  transition:all .2s ease-in-out;
  margin:0 5px;
}

.star:hover {
  color:#facc15; /* gold */
  transform:scale(1.3) rotate(-5deg);
  text-shadow:0 0 10px rgba(250,204,21,0.6);
}

.btn-back {
  background:#1e3a8a;
  color:#fff;
  border:none;
  border-radius:8px;
  padding:8px 14px;
}
.btn-back:hover {
  background:#b91c1c;
}

.alert-box{
  position:fixed;
  top:20px;
  right:20px;
  background:#16a34a;
  color:#fff;
  padding:10px 16px;
  border-radius:8px;
  display:none;
  z-index:9999;
}
.rating {
  display: inline-flex;
  align-items: center;
  gap: 4px;
}

.star {
  font-size: 2rem;
  color: #ccc;
  cursor: pointer;
  transition: transform 0.25s ease, color 0.25s ease, text-shadow 0.25s ease;
}

.star.active {
  color: gold;
  text-shadow: 0 0 10px rgba(255, 215, 0, 0.6);
  transform: scale(1.2);
}

.star.bounce {
  animation: bounceStar 0.4s ease;
}

@keyframes bounceStar {
  0% { transform: scale(1.2); }
  50% { transform: scale(1.4); }
  100% { transform: scale(1); }
}

/* area rating agar kontras */
.rating-box {
  background: rgba(255, 255, 255, 0.8);
  border-radius: 10px;
  padding: 12px 18px;
  display: inline-block;
  box-shadow: 0 2px 10px rgba(0,0,0,0.15);
}

</style>

</style>
</head>
<body>

<?php include("display_header.php"); ?>
<div id="alert" class="alert-box"></div>

<div class="container-fluid text-center">
  <div class="my-3">
    <button class="btn btn-back" onclick="history.back()">
      <i class="bi bi-arrow-left"></i> Back
    </button>
  </div>

  <img src="<?= $config['base_url'].'/uploads/originals/'.basename($ep['filename']) ?>"
       class="poster-full img-fluid" alt="<?= htmlspecialchars($ep['title']) ?>">

  <h4 class="fw-bold mt-4"><?= htmlspecialchars($ep['title']) ?></h4>
  <p class="text-muted"><?= ucfirst($ep['category']) ?> — <?= htmlspecialchars($ep['author']) ?></p>
  <p><i class="bi bi-eye"></i> <?= $ep['view_count'] + 1 ?> views</p>

  <!-- Rating kosong tapi aktif -->
<!-- Rating Area -->
<div class="rating-box mt-3">
    <div class="rating text-center mt-3" data-id="<?= $eposter['id'] ?>">
      <?php for ($i = 1; $i <= 5; $i++): ?>
        <span class="star" data-rate="<?= $i ?>">★</span>
      <?php endfor; ?>
    </div>
  <div class="small text-muted mt-1">
    Average: <?= number_format($avg,1) ?>/5 (<?= $total ?> votes)
  </div>
</div>

<p id="ratingMessage" class="text-center mt-2 text-warning fw-semibold"></p>

  <div class="my-4">
    <button class="btn btn-back" onclick="history.back()">
      <i class="bi bi-arrow-left"></i> Back
    </button>
  </div>
</div>
<footer class="text-center text-muted mt-4 small">
  Ratings closed at <?= date("d M Y H:i", strtotime($config['rate_deadline'])) ?> Western Indonesian Time
</footer>
<script>
function showAlert(msg){
  const a=document.getElementById('alert');
  a.textContent=msg; a.style.display='block';
  setTimeout(()=>a.style.display='none',2000);
}
document.addEventListener('DOMContentLoaded', function() {
  const ratingClosed = <?= $rating_closed ? 'true' : 'false' ?>;

  if (ratingClosed) {
    document.getElementById('ratingMessage').innerText = '⭐ Rarating is closed.;
    document.querySelectorAll('.rating .star').forEach(star => {
      star.style.opacity = '0.5';
      star.style.pointerEvents = 'none';
    });
    return; // Stop rating interaction
  }

  // Jika rating masih aktif
  document.querySelectorAll('.rating .star').forEach(star => {
    star.addEventListener('mouseenter', e => {
      const rate = parseInt(star.dataset.rate);
      document.querySelectorAll('.rating .star').forEach(s => {
        s.classList.toggle('active', parseInt(s.dataset.rate) <= rate);
      });
    });

    star.addEventListener('mouseleave', () => {
      document.querySelectorAll('.rating .star').forEach(s => s.classList.remove('active'));
    });

    star.addEventListener('click', e => {
      const rate = star.dataset.rate;
      const id = document.querySelector('.rating').dataset.id;

      fetch('rate.php', {
        method: 'POST',
        headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
        body: `id=${id}&rating=${rate}`
      })
      .then(res => res.json())
      .then(data => {
        const msg = document.getElementById('ratingMessage');
        msg.innerText = data.message;
        msg.style.color = data.success ? 'limegreen' : 'red';
      });
    });
  });
});
</script>
</body>
</html>
