<?php
// ajax/rate.php
require __DIR__ . '/../db.php';
require __DIR__ . '/../functions.php';

header('Content-Type: application/json');
$input = json_decode(file_get_contents('php://input'), true);
if (!$input) {
    echo json_encode(['success'=>false,'message'=>'Invalid input']); exit;
}
$eposter_id = (int)($input['eposter_id'] ?? 0);
$rating = (int)($input['rating'] ?? 0);
if ($eposter_id <= 0 || $rating < 1 || $rating > 5) {
    echo json_encode(['success'=>false,'message'=>'Invalid data']); exit;
}

$ip = get_client_ip();

// check already rated by ip
$stmt = $pdo->prepare("SELECT id FROM ratings WHERE eposter_id = ? AND ip_address = ?");
$stmt->execute([$eposter_id, $ip]);
if ($stmt->fetch()) {
    echo json_encode(['success'=>false,'message'=>'You have already rated this poster.']); exit;
}

$ins = $pdo->prepare("INSERT INTO ratings (eposter_id, ip_address, rating) VALUES (?,?,?)");
try {
    $ins->execute([$eposter_id, $ip, $rating]);
    echo json_encode(['success'=>true]);
} catch (Exception $e) {
    echo json_encode(['success'=>false,'message'=>'DB error']);
}
