<?php
session_start();
if (empty($_SESSION['admin_logged'])) { header('Location: login.php'); exit; }
require __DIR__ . '/../db.php';
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Daftar User</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<style>
.icon-btn { font-size: 1.2rem; margin: 0 5px; cursor: pointer; }
.icon-btn:hover { opacity: 0.7; }
</style>
</head>
<body class="bg-light">
<?php include 'navbar.php'; ?>
<div class="container py-4">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <h3 class="fw-bold text-dark">👤 Manajemen User</h3>
    <a href="add_user.php" class="btn btn-primary">➕ Tambah User</a>
  </div>

  <div class="card shadow-sm">
    <div class="card-body">
      <table class="table table-hover align-middle">
        <thead class="table-dark">
          <tr>
            <th width="60">ID</th>
            <th>Username</th>
            <th>Role</th>
            <th>Tanggal Dibuat</th>
            <th width="100" class="text-center">Aksi</th>
          </tr>
        </thead>
        <tbody>
        <?php
        $stmt = $pdo->query("SELECT * FROM users ORDER BY id DESC");
        foreach ($stmt as $row): ?>
          <tr>
            <td><?= $row['id'] ?></td>
            <td><?= htmlspecialchars($row['username']) ?></td>
            <td><?= htmlspecialchars($row['role']) ?></td>
            <td><?= $row['created_at'] ?></td>
            <td class="text-center">
              <a href="edit_user.php?id=<?= $row['id'] ?>" class="text-warning icon-btn" title="Edit">
                <i class="bi bi-pencil-square"></i>
              </a>
              <a href="delete_user.php?id=<?= $row['id'] ?>" class="text-danger icon-btn"
                 onclick="return confirm('Yakin ingin menghapus user ini?');" title="Hapus">
                <i class="bi bi-trash"></i>
              </a>
            </td>
          </tr>
        <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>
</body>
</html>
