<?php
session_start();
if (empty($_SESSION['admin_logged'])) {
  header('Location: login.php');
  exit;
}

require __DIR__ . '/../db.php';
require __DIR__ . '/../functions.php';

// Ambil data dari form
$title = trim($_POST['title'] ?? '');
$author = trim($_POST['author'] ?? '');
$category = trim($_POST['category'] ?? '');

// Pastikan semua input dan file diisi
if (empty($title) || empty($_FILES['file']['name']) || empty($_FILES['thumb']['name'])) {
  die('Data tidak lengkap.');
}

// Pastikan folder upload tersedia
$uploadDir = __DIR__ . '/../uploads/originals/';
$thumbDir  = __DIR__ . '/../uploads/thumbs/';
if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);
if (!is_dir($thumbDir)) mkdir($thumbDir, 0777, true);

// --- Upload File Original ---
$file = $_FILES['file'];
$ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
$allowed = ['jpg', 'jpeg', 'png', 'pdf'];

if (!in_array($ext, $allowed) || $file['error'] !== 0) {
  die('File original tidak valid.');
}

$basename = time() . '_' . preg_replace('/[^a-z0-9\.\-_]/i', '_', $file['name']);
$uploadPath = $uploadDir . $basename;

if (!move_uploaded_file($file['tmp_name'], $uploadPath)) {
  die('Gagal mengupload file original.');
}

// --- Upload Thumbnail ---
$thumbFile = $_FILES['thumb'];
$thumbExt = strtolower(pathinfo($thumbFile['name'], PATHINFO_EXTENSION));
$allowedThumb = ['jpg', 'jpeg', 'png'];

if (!in_array($thumbExt, $allowedThumb) || $thumbFile['error'] !== 0) {
  die('Thumbnail tidak valid.');
}

$thumbName = time() . '_thumb_' . preg_replace('/[^a-z0-9\.\-_]/i', '_', $thumbFile['name']);
$thumbPath = $thumbDir . $thumbName;

if (!move_uploaded_file($thumbFile['tmp_name'], $thumbPath)) {
  die('Gagal mengupload thumbnail.');
}

// --- Simpan ke database ---
$stmt = $pdo->prepare("
  INSERT INTO eposters (title, author, category, filename, thumb, created_at)
  VALUES (?, ?, ?, ?, ?, NOW())
");
$stmt->execute([$title, $author, $category, $basename, $thumbName]);

header('Location: dashboard.php?msg=uploaded');
exit;
