<?php
session_start();
if (empty($_SESSION['admin_logged'])) { header('Location: login.php'); exit; }
require __DIR__ . '/../db.php';
require __DIR__ . '/../functions.php';
$config = require __DIR__ . '/../config.php';

$err = $msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $title = trim($_POST['title'] ?? '');
    $author = trim($_POST['author'] ?? '');
    $category = $_POST['category'] ?? '';
    if ($title === '' || !in_array($category, ['surgical','pulmonology','oncology'])) {
        $err = 'Title & kategori wajib.';
    } elseif (!isset($_FILES['file'])) {
        $err = 'File wajib diupload.';
    } else {
        $file = $_FILES['file'];
        $allowed = ['pdf','jpg','jpeg','png','gif'];
        $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        if ($file['error'] !== 0 || !in_array($ext, $allowed)) {
            $err = 'Tipe file tidak diizinkan.';
        } else {
            // ensure dirs
            @mkdir($config['upload_dir'], 0777, true);
            @mkdir($config['thumb_dir'], 0777, true);

            $newname = time() . '_' . preg_replace('/[^a-z0-9\.\-_]/i','_', $file['name']);
            $origPath = $config['upload_dir'] . $newname;
            if (move_uploaded_file($file['tmp_name'], $origPath)) {
                // thumbnail: if image -> create thumb; if pdf -> use placeholder
                $thumbName = 'thumb_' . $newname . '.jpg';
                $thumbPath = $config['thumb_dir'] . $thumbName;
                if (in_array($ext, ['jpg','jpeg','png','gif'])) {
                    make_thumbnail($origPath, $thumbPath, 400, 400);
                } else {
                    // use generic pdf thumbnail in assets
                    copy(__DIR__ . '/../assets/pdf-thumb.png', $thumbPath);
                }

                $ins = $pdo->prepare("INSERT INTO eposters (title,author,category,filename,thumb) VALUES (?,?,?,?,?)");
                $ins->execute([$title,$author,$category,$newname,$thumbName]);
                $msg = 'Upload berhasil';
            } else $err = 'Gagal menyimpan file';
        }
    }
}
?>
<!doctype html>
<html>
<head><meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
<title>Upload ePoster</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="p-4">
<div class="container">
  <a href="dashboard.php" class="btn btn-link">&larr; Dashboard</a>
  <h4>Upload ePoster</h4>
  <?php if($err): ?><div class="alert alert-danger"><?= h($err) ?></div><?php endif; ?>
  <?php if($msg): ?><div class="alert alert-success"><?= h($msg) ?></div><?php endif; ?>

  <form method="post" enctype="multipart/form-data">
    <div class="mb-3"><label>Title</label><input name="title" class="form-control" required></div>
    <div class="mb-3"><label>Author</label><input name="author" class="form-control"></div>
    <div class="mb-3">
      <label>Kategori</label>
      <select name="category" class="form-select" required>
        <option value="">Pilih</option>
        <option value="surgical">Surgical</option>
        <option value="pulmonology">Pulmonology</option>
        <option value="oncology">Oncology</option>
        <option value="others">Others</option>        
      </select>
    </div>
    <div class="mb-3"><label>File (pdf/jpg/png)</label><input type="file" name="file" class="form-control" required></div>
    <button class="btn btn-primary">Upload</button>
  </form>
</div>
</body>
</html>
