<?php
session_start();
if (empty($_SESSION['admin_logged'])) { header('Location: login.php'); exit; }
require __DIR__ . '/../db.php';
require __DIR__ . '/../functions.php';
$config = require __DIR__ . '/../config.php';

// ====== RINGKASAN STATISTIK ======
$totalEposter = $pdo->query("SELECT COUNT(*) FROM eposters")->fetchColumn();
$totalRating  = $pdo->query("SELECT COUNT(*) FROM ratings")->fetchColumn();
$avgRating    = $pdo->query("SELECT ROUND(AVG(rating),2) FROM ratings")->fetchColumn();
$totalViews   = $pdo->query("SELECT SUM(view_count) FROM eposters")->fetchColumn();

// Poster terbaru
$latestPoster = $pdo->query("SELECT title, created_at FROM eposters ORDER BY created_at DESC LIMIT 1")->fetch(PDO::FETCH_ASSOC);

// Poster dengan rating tertinggi
$topPoster = $pdo->query("
    SELECT e.title, ROUND(AVG(r.rating),2) as avg
    FROM ratings r 
    JOIN eposters e ON e.id = r.eposter_id
    GROUP BY e.id
    ORDER BY avg DESC
    LIMIT 1
")->fetch(PDO::FETCH_ASSOC);

// ====== DATA GRAFIK ======
// Grafik rata-rata rating per poster
$chart1 = $pdo->query("
    SELECT e.title, ROUND(AVG(r.rating),2) as avg_rating
    FROM ratings r
    JOIN eposters e ON e.id = r.eposter_id
    GROUP BY e.id
    ORDER BY avg_rating DESC
    LIMIT 10
")->fetchAll(PDO::FETCH_ASSOC);

// Aktivitas rating per hari (7 hari terakhir)
$chart2 = $pdo->query("
    SELECT DATE(created_at) as tanggal, COUNT(*) as total
    FROM ratings
    WHERE created_at IS NOT NULL
    GROUP BY DATE(created_at)
    ORDER BY tanggal ASC
    LIMIT 7
")->fetchAll(PDO::FETCH_ASSOC);

// Kategori ePoster
$chart3 = $pdo->query("
    SELECT category, COUNT(*) as total
    FROM eposters
    GROUP BY category
")->fetchAll(PDO::FETCH_ASSOC);

// Aktivitas terakhir
$recent = $pdo->query("
    SELECT r.*, e.title 
    FROM ratings r 
    JOIN eposters e ON e.id = r.eposter_id
    ORDER BY r.created_at DESC 
    LIMIT 10
")->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Dashboard ePoster</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<style>
body {
  background-color: #f6f7fb;
}
.card-summary {
  border-radius: 15px;
  transition: transform .2s;
}
.card-summary:hover {
  transform: translateY(-5px);
}
.icon {
  font-size: 2rem;
  opacity: 0.8;
}
.chart-container {
  background: #fff;
  border-radius: 15px;
  padding: 20px;
  box-shadow: 0 3px 10px rgba(0,0,0,0.1);
}
</style>
</head>
<body class="p-4">

<div class="container">
  <div class="d-flex justify-content-between align-items-center mb-3">
    <a href="dashboard.php" class="back-btn"><i class="bi bi-arrow-left-circle"></i> Back Dashboard</a>
    <h3 class="fw-bold mb-4">📊 Detail Statistik ePoster</h3>
  </div>

  <!-- ===== Summary Cards ===== -->
  <div class="row g-3 mb-4">
    <div class="col-md-2">
      <div class="card card-summary text-center shadow-sm p-3">
        <div class="icon text-primary"><i class="bi bi-image"></i></div>
        <h5><?= $totalEposter ?></h5>
        <p class="text-muted small mb-0">Total ePoster</p>
      </div>
    </div>
    <div class="col-md-2">
      <div class="card card-summary text-center shadow-sm p-3">
        <div class="icon text-warning"><i class="bi bi-star-fill"></i></div>
        <h5><?= $totalRating ?></h5>
        <p class="text-muted small mb-0">Total Rating</p>
      </div>
    </div>
    <div class="col-md-2">
      <div class="card card-summary text-center shadow-sm p-3">
        <div class="icon text-success"><i class="bi bi-emoji-smile"></i></div>
        <h5><?= $avgRating ?: 0 ?></h5>
        <p class="text-muted small mb-0">Rata-rata Rating</p>
      </div>
    </div>
    <div class="col-md-2">
      <div class="card card-summary text-center shadow-sm p-3">
        <div class="icon text-info"><i class="bi bi-eye-fill"></i></div>
        <h5><?= $totalViews ?: 0 ?></h5>
        <p class="text-muted small mb-0">Total Views</p>
      </div>
    </div>
    <div class="col-md-2">
      <div class="card card-summary text-center shadow-sm p-3">
        <div class="icon text-secondary"><i class="bi bi-clock-history"></i></div>
        <h6 class="mb-0"><?= h($latestPoster['title'] ?? '-') ?></h6>
        <p class="text-muted small mb-0">Poster Terbaru</p>
      </div>
    </div>
    <div class="col-md-2">
      <div class="card card-summary text-center shadow-sm p-3">
        <div class="icon text-danger"><i class="bi bi-trophy-fill"></i></div>
        <h6 class="mb-0"><?= h($topPoster['title'] ?? '-') ?></h6>
        <p class="text-muted small mb-0">Top Rating (<?= $topPoster['avg'] ?? '-' ?>)</p>
      </div>
    </div>
  </div>

  <!-- ===== Charts ===== -->
  <div class="row g-4 mb-4">
    <div class="col-md-6">
      <div class="chart-container">
        <h6 class="fw-bold mb-3">⭐ Rata-rata Rating per Poster</h6>
        <canvas id="chart1"></canvas>
      </div>
    </div>
    <div class="col-md-6">
      <div class="chart-container">
        <h6 class="fw-bold mb-3">📅 Aktivitas Rating per Hari</h6>
        <canvas id="chart2"></canvas>
      </div>
    </div>
  </div>

  <div class="row g-4 mb-5">
    <div class="col-md-6">
      <div class="chart-container">
        <h6 class="fw-bold mb-3">🎨 Kategori ePoster</h6>
        <canvas id="chart3"></canvas>
      </div>
    </div>
  </div>

  <!-- ===== Tabel Aktivitas ===== -->
  <div class="chart-container">
    <h6 class="fw-bold mb-3">🕒 Aktivitas Rating Terbaru</h6>
    <table class="table table-striped table-hover">
      <thead>
        <tr>
          <th>Poster</th>
          <th>Rating</th>
          <th>IP Address</th>
          <th>Token</th>
          <th>Tanggal</th>
        </tr>
      </thead>
      <tbody>
      <?php foreach($recent as $r): ?>
        <tr>
          <td><?= h($r['title']) ?></td>
          <td><span class="badge bg-<?= $r['rating'] >=4 ? 'success' : ($r['rating']==3?'warning':'danger') ?>">
            <?= $r['rating'] ?> ★</span></td>
          <td><?= h($r['ip_address']) ?></td>
          <td class="text-muted small"><?= substr(h($r['token']),0,10) ?>...</td>
          <td><?= h($r['created_at']) ?></td>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>

</div>

<script>
// === Data dari PHP ===
const chart1Data = <?= json_encode($chart1) ?>;
const chart2Data = <?= json_encode($chart2) ?>;
const chart3Data = <?= json_encode($chart3) ?>;

// === Chart.js ===
new Chart(document.getElementById('chart1'), {
  type: 'bar',
  data: {
    labels: chart1Data.map(x => x.title),
    datasets: [{
      label: 'Rata-rata Rating',
      data: chart1Data.map(x => x.avg_rating),
      backgroundColor: '#f1c40f'
    }]
  },
  options: {responsive: true, plugins: {legend: {display:false}}}
});

new Chart(document.getElementById('chart2'), {
  type: 'line',
  data: {
    labels: chart2Data.map(x => x.tanggal),
    datasets: [{
      label: 'Jumlah Rating',
      data: chart2Data.map(x => x.total),
      borderColor: '#3498db',
      fill: false,
      tension: 0.3
    }]
  },
  options: {responsive: true}
});

new Chart(document.getElementById('chart3'), {
  type: 'doughnut',
  data: {
    labels: chart3Data.map(x => x.category),
    datasets: [{
      data: chart3Data.map(x => x.total),
      backgroundColor: ['#3498db','#9b59b6','#e67e22','#2ecc71','#e74c3c']
    }]
  },
  options: {responsive: true}
});
</script>

</body>
</html>
