<?php
session_start();
if (empty($_SESSION['admin_logged'])) { header('Location: login.php'); exit; }
require __DIR__ . '/../db.php';
require __DIR__ . '/../functions.php';
$config = require __DIR__ . '/../config.php';

$selected = $_GET['screen'] ?? 'Layar1';

// Ambil setting aktif
$stmt = $pdo->prepare("SELECT * FROM slideshow_settings WHERE screen_name = ?");
$stmt->execute([$selected]);
$setting = $stmt->fetch();

// Simpan perubahan range / speed
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['save'])) {
  $screen = $_POST['screen_name'];
  $start = (int)$_POST['start_order'];
  $end = (int)$_POST['end_order'];
  $speed = (int)$_POST['speed_ms'];
  $pdo->prepare("UPDATE slideshow_settings SET start_order=?, end_order=?, speed_ms=? WHERE screen_name=?")
      ->execute([$start, $end, $speed, $screen]);
  header("Location: slideshow.php?screen=" . urlencode($screen));
  exit;
}

// Ambil data ePoster berdasarkan range sort_order
$start = $setting['start_order'] ?? 1;
$end = $setting['end_order'] ?? 999999;
$stmt = $pdo->prepare("SELECT * FROM eposters WHERE sort_order BETWEEN ? AND ? ORDER BY sort_order ASC");
$stmt->execute([$start, $end]);
$eposters = $stmt->fetchAll();
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Slideshow ePoster</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
:root {
  --c1:#c7cfda; --c2:#354478; --c3:#d9dad8; --c4:#8e2d2d;
}
body {
  background:linear-gradient(180deg,var(--c1),white);
  overflow:hidden;
}
.carousel-item img {
  object-fit:contain;
  height:85vh;
  margin:auto;
  border-radius:12px;
  box-shadow:0 0 20px rgba(0,0,0,0.3);
}
.hide-menu { display:none; }
.fullscreen-active { background:#000; color:#fff; }
#btn-exit {
  position:fixed;
  bottom:20px;
  right:30px;
  z-index:9999;
  opacity:0;
  transition:opacity 0.5s;
}
#btn-exit.show { opacity:1; }
</style>
</head>
<body class="p-3">
<div class="container-fluid">

  <div id="menu-area" class="mb-3">
    <div class="d-flex justify-content-between align-items-center">
      <h4>🎬 Slideshow ePoster</h4>
      <a href="dashboard.php" class="btn btn-outline-dark btn-sm">Kembali</a>
    </div>

    <form method="get" class="my-3">
      <label>Pilih Layar:</label>
      <select name="screen" onchange="this.form.submit()" class="form-select w-auto d-inline-block">
        <?php for($i=1;$i<=5;$i++):
          $name = 'Layar'.$i; ?>
          <option value="<?= $name ?>" <?= $selected==$name?'selected':'' ?>><?= $name ?></option>
        <?php endfor; ?>
      </select>
    </form>

    <form method="post" class="card p-3 shadow-sm" style="max-width:500px;">
      <input type="hidden" name="screen_name" value="<?= h($selected) ?>">
      <div class="row mb-2">
        <div class="col">
          <label class="form-label">Nomor Urut Awal</label>
          <input type="number" name="start_order" class="form-control" value="<?= h($setting['start_order']) ?>">
        </div>
        <div class="col">
          <label class="form-label">Nomor Urut Akhir</label>
          <input type="number" name="end_order" class="form-control" value="<?= h($setting['end_order']) ?>">
        </div>
      </div>
      <div class="mb-2">
        <label class="form-label">Speed (ms)</label>
        <input type="number" name="speed_ms" class="form-control" value="<?= h($setting['speed_ms']) ?>">
        <div class="form-text">Contoh: 3000 = 3 detik</div>
      </div>
      <button class="btn btn-primary" name="save">💾 Simpan Pengaturan</button>
      <button type="button" id="btn-start" class="btn btn-success">▶️ Mulai Slideshow</button>
    </form>
  </div>

  <div id="slideshow-area" class="hide-menu mt-4">
    <?php if(count($eposters) > 0): ?>
      <div id="posterCarousel" class="carousel slide" data-bs-ride="carousel" data-bs-interval="<?= (int)$setting['speed_ms'] ?>">
        <div class="carousel-inner">
          <?php $first = true; foreach($eposters as $ep): ?>
            <div class="carousel-item <?= $first ? 'active' : '' ?>">
              <img src="<?= h($config['base_url'].'/uploads/originals/'.basename($ep['filename'])) ?>" 
                   class="d-block w-100" alt="<?= h($ep['title']) ?>">
              <div class="carousel-caption d-none d-md-block">
                <h5><?//= h($ep['title']) ?></h5>
                <p><?//= h($ep['author']) ?></p>
              </div>
            </div>
          <?php $first = false; endforeach; ?>
        </div>
        <button class="carousel-control-prev" type="button" data-bs-target="#posterCarousel" data-bs-slide="prev">
          <span class="carousel-control-prev-icon"></span>
        </button>
        <button class="carousel-control-next" type="button" data-bs-target="#posterCarousel" data-bs-slide="next">
          <span class="carousel-control-next-icon"></span>
        </button>
      </div>

      <button class="btn btn-danger" id="btn-exit">❌ Keluar / ESC</button>
    <?php else: ?>
      <div class="alert alert-info mt-3">Tidak ada ePoster dalam range nomor urut ini.</div>
    <?php endif; ?>
  </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
async function openFullscreen(elem){
  if(elem.requestFullscreen) await elem.requestFullscreen();
  else if(elem.webkitRequestFullscreen) await elem.webkitRequestFullscreen();
  else if(elem.msRequestFullscreen) await elem.msRequestFullscreen();
  document.body.classList.add('fullscreen-active');
}

function exitFullscreen(){
  if(document.exitFullscreen) document.exitFullscreen();
  else if(document.webkitExitFullscreen) document.webkitExitFullscreen();
  else if(document.msExitFullscreen) document.msExitFullscreen();
  document.body.classList.remove('fullscreen-active');
}

// mulai slideshow
document.getElementById('btn-start')?.addEventListener('click', ()=>{
  document.getElementById('menu-area').classList.add('hide-menu');
  document.getElementById('slideshow-area').classList.remove('hide-menu');
  openFullscreen(document.documentElement);
});

// tombol keluar
const btnExit = document.getElementById('btn-exit');
btnExit.addEventListener('click', ()=>{
  exitFullscreen();
  document.getElementById('menu-area').classList.remove('hide-menu');
  document.getElementById('slideshow-area').classList.add('hide-menu');
});

// sembunyikan tombol exit otomatis
let hideTimeout;
document.addEventListener('mousemove', ()=>{
  if(document.fullscreenElement){
    btnExit.classList.add('show');
    clearTimeout(hideTimeout);
    hideTimeout = setTimeout(()=>btnExit.classList.remove('show'), 2000);
  }
});

// keluar fullscreen bila ESC ditekan
document.addEventListener('fullscreenchange', ()=>{
  if(!document.fullscreenElement){
    document.getElementById('menu-area').classList.remove('hide-menu');
    document.getElementById('slideshow-area').classList.add('hide-menu');
    document.body.classList.remove('fullscreen-active');
  }
});
</script>
</body>
</html>
