<?php 
// admin/login.php
session_set_cookie_params(4 * 24 * 60 * 60); // 4 hari (dalam detik)
session_start();

require __DIR__ . '/../db.php';

$err = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $username = $_POST['username'] ?? '';
    $password = $_POST['password'] ?? '';

    // fetch user
    $stmt = $pdo->prepare("SELECT * FROM users WHERE username = ?");
    $stmt->execute([$username]);
    $user = $stmt->fetch();

    if ($user && password_verify($password, $user['password'])) {
        // set session
        $_SESSION['admin_logged'] = true;
        $_SESSION['admin_user'] = $user['username'];
        $_SESSION['login_time'] = time(); // waktu login disimpan
        $_SESSION['expire_time'] = time() + (4 * 24 * 60 * 60); // 4 hari ke depan

        header('Location: dashboard.php');
        exit;
    } else {
        $err = 'Login gagal';
    }
}
?>
<!doctype html>
<html>
<head>
  <meta charset="utf-8"><meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Admin Login</title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>body{background:#c7cfda}</style>
</head>
<body class="d-flex align-items-center" style="height:100vh;">
  <div class="container">
    <div class="row justify-content-center">
      <div class="col-md-4">
        <div class="card shadow">
          <div class="card-body">
            <h5 class="card-title">Admin Login</h5>
            <?php if($err): ?>
              <div class="alert alert-danger"><?= htmlspecialchars($err) ?></div>
            <?php endif; ?>
            <form method="post">
              <div class="mb-3">
                <label class="form-label">Username</label>
                <input name="username" class="form-control" required>
              </div>
              <div class="mb-3">
                <label class="form-label">Password</label>
                <input name="password" type="password" class="form-control" required>
              </div>
              <button class="btn btn-primary w-100">Login</button>
            </form>
            <hr>
            <a href="../index.php"><< Back Home</a></p>
          </div>
        </div>
      </div>
    </div>
  </div>
</body>
</html>
