<?php
session_start();
if (empty($_SESSION['admin_logged'])) { 
    header('Location: login.php'); 
    exit; 
}

require __DIR__ . '/../db.php';
require __DIR__ . '/../vendor/autoload.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

// Ambil data eposter beserta statistik
$stmt = $pdo->query("
    SELECT 
        e.id, 
        e.title, 
        e.author, 
        e.category, 
        e.created_at,
        IFNULL(ROUND((SELECT AVG(r.rating) FROM ratings r WHERE r.eposter_id = e.id), 2), 0) AS avg_rating,
        (SELECT COUNT(*) FROM ratings r WHERE r.eposter_id = e.id) AS total_votes,
        IFNULL(e.view_count, 0) AS total_views
    FROM eposters e
    ORDER BY e.created_at DESC
");
$data = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Buat spreadsheet
$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();
$sheet->setTitle('ePosters');

// Header kolom
$headers = ['ID', 'Title', 'Author', 'Category', 'Created At', 'Avg Rating', 'Total Votes', 'Views'];
$sheet->fromArray($headers, NULL, 'A1');

// Isi data
$row = 2;
foreach ($data as $d) {
    $sheet->fromArray([
        $d['id'],
        $d['title'],
        $d['author'],
        $d['category'],
        $d['created_at'],
        $d['avg_rating'],
        $d['total_votes'],
        $d['total_views']
    ], NULL, 'A' . $row);
    $row++;
}

// Styling sederhana
$sheet->getStyle('A1:H1')->getFont()->setBold(true);
$sheet->getColumnDimension('B')->setWidth(40);
$sheet->getColumnDimension('C')->setWidth(25);
$sheet->getColumnDimension('D')->setWidth(20);
$sheet->getColumnDimension('E')->setWidth(20);
$sheet->getColumnDimension('F')->setWidth(15);
$sheet->getColumnDimension('G')->setWidth(15);
$sheet->getColumnDimension('H')->setWidth(12);

// Output ke browser
$writer = new Xlsx($spreadsheet);
$fname = 'eposters_export_' . date('Ymd_His') . '.xlsx';
header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
header('Content-Disposition: attachment;filename="' . $fname . '"');
header('Cache-Control: max-age=0');
$writer->save('php://output');
exit;
