<?php
session_start();
if (empty($_SESSION['admin_logged'])) {
  header('Location: login.php');
  exit;
}

require __DIR__ . '/../db.php';
require __DIR__ . '/../functions.php';

$id = (int)$_POST['id'];
$title = trim($_POST['title'] ?? '');
$author = trim($_POST['author'] ?? '');
$category = trim($_POST['category'] ?? '');

$old = $pdo->prepare("SELECT * FROM eposters WHERE id=?");
$old->execute([$id]);
$e = $old->fetch();
if (!$e) die('Poster tidak ditemukan.');

$filename = $e['filename'];
$thumb = $e['thumb'];

// Pastikan folder upload tersedia
$uploadDir = __DIR__ . '/../uploads/originals/';
$thumbDir  = __DIR__ . '/../uploads/thumbs/';
if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);
if (!is_dir($thumbDir)) mkdir($thumbDir, 0777, true);

// --- Ganti File Original (jika diupload) ---
if (!empty($_FILES['file']['name'])) {
  $file = $_FILES['file'];
  $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
  $allowed = ['jpg','jpeg','png','pdf'];

  if (in_array($ext, $allowed) && $file['error'] == 0) {
    $basename = time().'_'.preg_replace('/[^a-z0-9\.\-_]/i', '_', $file['name']);
    $uploadPath = $uploadDir . $basename;
    move_uploaded_file($file['tmp_name'], $uploadPath);

    // Hapus file lama
    @unlink($uploadDir . $e['filename']);
    $filename = $basename;
  }
}

// --- Ganti Thumbnail (jika diupload) ---
if (!empty($_FILES['thumb']['name'])) {
  $thumbFile = $_FILES['thumb'];
  $thumbExt = strtolower(pathinfo($thumbFile['name'], PATHINFO_EXTENSION));
  $allowedThumb = ['jpg','jpeg','png'];

  if (in_array($thumbExt, $allowedThumb) && $thumbFile['error'] == 0) {
    $thumbName = time().'_thumb_'.preg_replace('/[^a-z0-9\.\-_]/i', '_', $thumbFile['name']);
    $thumbPath = $thumbDir . $thumbName;
    move_uploaded_file($thumbFile['tmp_name'], $thumbPath);

    // Hapus thumbnail lama
    @unlink($thumbDir . $e['thumb']);
    $thumb = $thumbName;
  }
}

// --- Update ke database ---
$stmt = $pdo->prepare("UPDATE eposters 
  SET title=?, author=?, category=?, filename=?, thumb=? 
  WHERE id=?");
$stmt->execute([$title, $author, $category, $filename, $thumb, $id]);

header('Location: dashboard.php?msg=updated');
exit;
