<?php
session_start();
if (empty($_SESSION['admin_logged'])) { header('Location: login.php'); exit; }
require __DIR__ . '/../db.php';
require __DIR__ . '/../functions.php';

$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;

// Ambil data poster
$stmt = $pdo->prepare("SELECT * FROM eposters WHERE id = ?");
$stmt->execute([$id]);
$poster = $stmt->fetch();

if (!$poster) {
  die("<h3>Poster tidak ditemukan.</h3>");
}

// Hitung statistik rating
$avgRating = $pdo->prepare("SELECT ROUND(AVG(rating),1) FROM ratings WHERE eposter_id = ?");
$avgRating->execute([$id]);
$avg = $avgRating->fetchColumn() ?: 0;

$totalVotes = $pdo->prepare("SELECT COUNT(*) FROM ratings WHERE eposter_id = ?");
$totalVotes->execute([$id]);
$total = $totalVotes->fetchColumn();

$breakdownStmt = $pdo->prepare("SELECT rating, COUNT(*) AS jumlah FROM ratings WHERE eposter_id = ? GROUP BY rating ORDER BY rating DESC");
$breakdownStmt->execute([$id]);
$breakdown = $breakdownStmt->fetchAll(PDO::FETCH_KEY_PAIR);

// View count (sudah disimpan di kolom view_count)
$viewCount = (int)$poster['view_count'];
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Detail ePoster - Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">
<style>
body { background: #f5f7fa; }
.container { max-width: 1200px; }
.poster-img {
  width: 100%;
  border-radius: 10px;
  object-fit: contain;
  background: #fff;
  box-shadow: 0 3px 10px rgba(0,0,0,0.15);
}
.stat-box {
  background: #fff;
  border-radius: 10px;
  padding: 20px;
  box-shadow: 0 3px 10px rgba(0,0,0,0.1);
}
.rating-bar {
  height: 10px;
  background: #dee2e6;
  border-radius: 4px;
  overflow: hidden;
  margin-top: 4px;
}
.rating-fill {
  height: 100%;
  background: #ffc107;
}
.star {
  color: #ffc107;
  font-size: 1.3rem;
}
.back-btn {
  text-decoration: none;
  color: #555;
}
.back-btn:hover { color: #000; }
</style>
</head>
<body>
<div class="container py-4">

  <div class="d-flex justify-content-between align-items-center mb-3">
    <a href="dashboard.php" class="back-btn"><i class="bi bi-arrow-left-circle"></i> Back Dashboard</a>
    <h4 class="fw-bold mb-0">📊 Detail Statistik ePoster</h4>
  </div>

  <div class="row g-4">
    <div class="col-md-7">
      <img src="<?= h($config['base_url'].'/uploads/originals/'.basename($poster['filename'])) ?>" class="poster-img" alt="<?= h($poster['title']) ?>">
    </div>
    <div class="col-md-5">
      <div class="stat-box">
        <h5 class="fw-bold mb-2">><?= h($poster['sort_order']) ?> - <?= h($poster['title']) ?></h5>
        <p class="text-muted mb-1">Kategori: <strong><?= h($poster['category']) ?></strong></p>
        <p class="text-muted mb-3">Diupload: <?= date('d M Y, H:i', strtotime($poster['created_at'])) ?></p>

        <hr>
        <div class="mb-3">
          <div><i class="bi bi-eye"></i> <strong><?= $viewCount ?></strong> views</div>
          <div><i class="bi bi-star-fill text-warning"></i> Rata-rata: <strong><?= $avg ?></strong> / 5 (<?= $total ?> penilai)</div>
        </div>

        <h6 class="fw-bold mt-3 mb-2">📈 Breakdown Rating</h6>
        <?php
        for ($i = 5; $i >= 1; $i--):
          $count = isset($breakdown[$i]) ? $breakdown[$i] : 0;
          $percent = $total > 0 ? round(($count / $total) * 100) : 0;
        ?>
        <div class="d-flex align-items-center mb-2">
          <div style="width: 60px;">
            <span class="star"><?= str_repeat('★', $i) ?></span>
          </div>
          <div class="flex-grow-1 mx-2">
            <div class="rating-bar">
              <div class="rating-fill" style="width: <?= $percent ?>%;"></div>
            </div>
          </div>
          <div style="width: 40px;" class="text-end"><?= $count ?></div>
        </div>
        <?php endfor; ?>
      </div>
    </div>
  </div>
</div>
</body>
</html>
