<?php
session_start();
if (empty($_SESSION['admin_logged'])) { header('Location: login.php'); exit; }
require __DIR__ . '/../db.php';

$id = (int)($_GET['id'] ?? 0);
$stmt = $pdo->prepare("SELECT * FROM users WHERE id = ?");
$stmt->execute([$id]);
$user = $stmt->fetch();
if (!$user) { die("User tidak ditemukan."); }
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Edit User</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<?php include 'navbar.php'; ?>
<div class="container py-4" style="max-width:600px;">
  <div class="card shadow-sm">
    <div class="card-header bg-warning text-dark fw-bold">Edit User</div>
    <div class="card-body">
      <form action="edit_user_process.php" method="POST">
        <input type="hidden" name="id" value="<?= $user['id'] ?>">
        <div class="mb-3">
          <label class="form-label">Username</label>
          <input type="text" name="username" value="<?= htmlspecialchars($user['username']) ?>" class="form-control" required>
        </div>
        <div class="mb-3">
          <label class="form-label">Password (kosongkan jika tidak ingin diubah)</label>
          <input type="password" name="password" class="form-control">
        </div>
        <div class="mb-3">
          <label class="form-label">Role</label>
          <select name="role" class="form-select">
            <option value="admin" <?= $user['role']=='admin'?'selected':'' ?>>Admin</option>
            <option value="editor" <?= $user['role']=='editor'?'selected':'' ?>>Editor</option>
            <option value="viewer" <?= $user['role']=='viewer'?'selected':'' ?>>Viewer</option>
          </select>
        </div>
        <div class="text-end">
          <a href="users.php" class="btn btn-secondary">Batal</a>
          <button type="submit" class="btn btn-success">Simpan Perubahan</button>
        </div>
      </form>
    </div>
  </div>
</div>
</body>
</html>
