<?php
session_start();
if (empty($_SESSION['admin_logged'])) { header('Location: login.php'); exit; }
require __DIR__ . '/../db.php';
require __DIR__ . '/../functions.php';

// Pencarian
$keyword = $_GET['q'] ?? '';
$category = $_GET['category'] ?? '';

$sql = "SELECT e.*, 
        (SELECT COUNT(*) FROM ratings r WHERE r.eposter_id = e.id) AS votes,
        IFNULL(ROUND((SELECT AVG(r.rating) FROM ratings r WHERE r.eposter_id = e.id),1),0) AS avg
        FROM eposters e WHERE 1=1";

$params = [];
if ($keyword) {
  $sql .= " AND (e.title LIKE ? OR e.author LIKE ?)";
  $params[] = "%$keyword%"; $params[] = "%$keyword%";
}
if ($category) {
  $sql .= " AND e.category = ?";
  $params[] = $category;
}
$sql .= " ORDER BY e.sort_order ASC";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$ep = $stmt->fetchAll();

// Ambil kategori unik
$cats = $pdo->query("SELECT DISTINCT category FROM eposters ORDER BY category")->fetchAll(PDO::FETCH_COLUMN);
?>
<!doctype html>
<html lang="id">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width,initial-scale=1">
<title>Dashboard Admin</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<style>
:root{
  --bg-main: #e7ebf2;
  --bg-card: #ffffffee;
  --text-main: #2f3640;
  --accent: #354478;
  --accent-light: #c7cfda;
  --accent-red: #8e2d2d;
  --soft-border: rgba(0,0,0,0.05);
}

[data-theme="dark"] {
  --bg-main: #141417;
  --bg-card: #1e2126;
  --text-main: #e0e3ea;
  --accent: #c7cfda;
  --accent-light: #2b3242;
  --accent-red: #d67a6a;
  --soft-border: rgba(255,255,255,0.05);
}

body {
  background: var(--bg-main);
  color: var(--text-main);
  font-family: 'Segoe UI', sans-serif;
  -webkit-font-smoothing: antialiased;
  transition: background .3s, color .3s;
}

/* Header */
.dashboard-header {
  background: var(--bg-card);
  border-radius: 12px;
  padding: 1rem 1.2rem;
  box-shadow: 0 4px 12px rgba(0,0,0,0.06);
  margin-bottom: 1.5rem;
  display:flex;
  align-items:center;
  justify-content:space-between;
  gap:10px;
}

.dashboard-header h3 {
  margin: 0;
  font-weight:600;
  color: var(--accent);
}

/* Buttons */
.action-buttons .btn {
  border-radius: 10px;
  font-size: 0.85rem;
  padding: 6px 10px;
  border: none;
  transition: background .2s, transform .2s;
}
.action-buttons .btn:hover { transform: translateY(-2px); }

.btn-success {
  background: var(--accent);
  border: none;
}
.btn-outline-success {
  border: 1px solid var(--accent);
  color: var(--accent);
}
.btn-outline-primary {
  border: 1px solid #4e75d3;
  color: #4e75d3;
}

/* Table */
.table-wrapper {
  background: var(--bg-card);
  border-radius: 10px;
  padding: 1rem;
  box-shadow: 0 4px 12px rgba(0,0,0,0.05);
  border: 1px solid var(--soft-border);
}
.table thead {
  background: var(--accent-light);
  color: var(--accent);
}
.table td, .table th {
  vertical-align: middle;
}

.thumb {
  width: 70px;
  height: 70px;
  border-radius: 8px;
  object-fit: cover;
  border: 1px solid var(--soft-border);
}

.icon-btn {
  border: none;
  background: none;
  font-size: 1.2rem;
  color: var(--accent);
  transition: transform .15s, color .15s;
}
.icon-btn:hover { color: var(--accent-red); transform: scale(1.15); }

/* Editable number cell */
.editable-order {
  cursor: text;
  font-weight: 600;
  color: var(--accent);
}

/* Theme toggle */
.theme-toggle {
  border: 1px solid var(--soft-border);
  background: transparent;
  border-radius: 10px;
  padding: 6px 10px;
  cursor: pointer;
  display:flex;
  align-items:center;
  gap:8px;
  color: var(--accent);
}
.theme-toggle:hover { background: var(--accent-light); }

/* Responsive */
@media (max-width:768px){
  .dashboard-header{flex-direction:column;align-items:flex-start;}
  .action-buttons{flex-wrap:wrap;}
}
</style>
</head>

<body>
<div class="container-fluid py-4">

  <div class="dashboard-header">
    <div class="d-flex align-items-center gap-2">
      <h3><i class="bi bi-speedometer2"></i> Dashboard</h3>
      <small class="text-muted">Admin Panel</small>
    </div>
    <div class="d-flex align-items-center gap-2">
      <div class="action-buttons d-flex align-items-center">
        <button class="btn btn-success btn-sm" data-bs-toggle="modal" data-bs-target="#uploadModal">
          <i class="bi bi-upload"></i> Upload ePoster
        </button>
        <a href="slideshow.php" class="btn btn-outline-success btn-sm"><i class="bi bi-play-circle"></i> Slideshow</a>
        <a href="statistik.php" class="btn btn-outline-success btn-sm"><i class="bi bi-bar-chart-fill"></i> Statistik</a>      
        <a href="export.php" class="btn btn-outline-primary btn-sm"><i class="bi bi-file-earmark-excel"></i> Export</a>
        <a href="users.php" class="btn btn-outline-primary btn-sm"><i class="bi bi-people"></i> Users</a>
        <a href="logout.php" class="btn btn-danger btn-sm"><i class="bi bi-box-arrow-right"></i> Logout</a>
      </div>
      <button id="themeToggle" class="theme-toggle"><i id="themeIcon" class="bi bi-moon"></i><span id="themeLabel">Dark</span></button>
    </div>
  </div>

  <!-- Filter -->
  <form method="get" class="row g-2 mb-4">
    <div class="col-sm-6 col-md-4">
      <input type="text" name="q" value="<?= h($keyword) ?>" class="form-control" placeholder="Cari title atau author...">
    </div>
    <div class="col-sm-4 col-md-3">
      <select name="category" class="form-select">
        <option value="">Semua Kategori</option>
        <?php foreach($cats as $c): ?>
          <option value="<?= h($c) ?>" <?= $c==$category?'selected':'' ?>><?= ucfirst($c) ?></option>
        <?php endforeach; ?>
      </select>
    </div>
    <div class="col-sm-2 col-md-2">
      <button class="btn btn-primary w-100"><i class="bi bi-search"></i> Cari</button>
    </div>
  </form>

  <!-- Table -->
  <div class="table-wrapper">
    <div class="table-responsive">
      <table class="table table-striped align-middle">
        <thead>
          <tr>
            <th>No</th>
            <th>Thumbnail</th>
            <th>Title</th>
            <th>Category</th>
            <th>Votes</th>
            <th>Avg</th>
            <th>Aksi</th>
          </tr>
        </thead>
        <tbody>
          <?php foreach($ep as $e): ?>
          <tr>
            <td contenteditable="true" class="editable-order text-center" data-id="<?= $e['id'] ?>"><?= (int)$e['sort_order'] ?></td>
            <td><img src="<?= h($config['base_url'].'/uploads/thumbs/'.basename($e['thumb'])) ?>" class="thumb"></td>
            <td><?= h($e['title']) ?></td>
            <td><?= h($e['category']) ?></td>
            <td><?= $e['votes'] ?></td>
            <td><?= $e['avg'] ?></td>
            <td>
              <a href="eposter_detail.php?id=<?= $e['id'] ?>" target="_blank" class="icon-btn" title="Detail"><i class="bi bi-eye"></i></a>
              <a href="#" class="icon-btn text-warning" title="Edit" onclick="openEditModal(<?= $e['id'] ?>)"><i class="bi bi-pencil-square"></i></a>
              <a href="eposter_delete.php?id=<?= $e['id'] ?>" class="icon-btn text-danger" title="Hapus" onclick="return confirm('Yakin ingin menghapus?');"><i class="bi bi-trash"></i></a>
            </td>
          </tr>
          <?php endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<!-- Modal Upload --> 
<div class="modal fade" id="uploadModal" tabindex="-1" aria-hidden="true">
  <div class="modal-dialog modal-lg modal-dialog-centered">
    <div class="modal-content">
      <form action="upload_process.php" method="POST" enctype="multipart/form-data">
        <div class="modal-header bg-primary text-white">
          <h5 class="modal-title"><i class="bi bi-upload"></i> Upload ePoster Baru</h5>
          <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
        </div>

        <div class="modal-body">
          <div class="mb-3">
            <label>Title</label>
            <input name="title" class="form-control" required>
          </div>

          <div class="mb-3">
            <label>Author</label>
            <input name="author" class="form-control">
          </div>

          <div class="mb-3">
            <label>Kategori</label>
            <select name="category" class="form-select" required>
              <option value="">Pilih</option>
              <option value="surgical">Surgical</option>
              <option value="pulmonology">Pulmonology</option>
              <option value="oncology">Oncology</option>
              <option value="others">Others</option>
            </select>
          </div>

          <div class="mb-3">
            <label>File Original (pdf/jpg/png)</label>
            <input type="file" name="file" class="form-control" accept=".jpg,.jpeg,.png,.pdf" required>
          </div>

          <div class="mb-3">
            <label>Thumbnail (jpg/png)</label>
            <input type="file" name="thumb" class="form-control" accept=".jpg,.jpeg,.png" required>
            <small class="text-muted">Gunakan gambar kecil dengan rasio 4:3 atau 16:9 agar tampilan rapi.</small>
          </div>
        </div>

        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
          <button type="submit" class="btn btn-primary"><i class="bi bi-cloud-arrow-up"></i> Upload</button>
        </div>
      </form>
    </div>
  </div>
</div>


<!-- Edit Modal -->
<div class="modal fade" id="editModal" tabindex="-1">
  <div class="modal-dialog modal-lg">
    <div class="modal-content">
      <form id="editForm" action="eposter_edit_process.php" method="post" enctype="multipart/form-data">
        <div class="modal-header">
          <h5 class="modal-title">Edit ePoster</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
        </div>
        <div class="modal-body" id="editModalBody"></div>
        <div class="modal-footer">
          <button class="btn btn-primary">Simpan Perubahan</button>
        </div>
      </form>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script>
document.addEventListener('DOMContentLoaded', () => {
  document.querySelectorAll('.editable-order').forEach(cell => {
    cell.addEventListener('focus', () => cell.dataset.original = cell.innerText.trim());
    cell.addEventListener('blur', () => {
      const newValue = cell.innerText.trim();
      const oldValue = cell.dataset.original;
      const id = cell.dataset.id;
      if (newValue !== oldValue && !isNaN(newValue) && newValue !== '') {
        fetch('update_order.php', {
          method: 'POST',
          headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
          body: `id=${id}&sort_order=${newValue}`
        }).then(r => r.text()).then(resp => {
          if (resp.trim() !== 'ok') alert('Gagal memperbarui nomor urut');
        }).catch(() => alert('Terjadi kesalahan koneksi.'));
      }
    });
    cell.addEventListener('keydown', e => { if (e.key === 'Enter') cell.blur(); });
  });
});

function openEditModal(id){
  fetch('eposter_edit.php?id='+id)
    .then(r=>r.text())
    .then(html=>{
      document.getElementById('editModalBody').innerHTML = html;
      new bootstrap.Modal(document.getElementById('editModal')).show();
    });
}

// Dark mode toggle
(function(){
  const root = document.documentElement;
  const icon = document.getElementById('themeIcon');
  const label = document.getElementById('themeLabel');
  const saved = localStorage.getItem('theme');
  if(saved==='dark'){ root.setAttribute('data-theme','dark'); icon.className='bi bi-sun'; label.textContent='Light'; }

  document.getElementById('themeToggle').addEventListener('click',()=>{
    if(root.getAttribute('data-theme')==='dark'){
      root.removeAttribute('data-theme');
      localStorage.setItem('theme','light');
      icon.className='bi bi-moon'; label.textContent='Dark';
    } else {
      root.setAttribute('data-theme','dark');
      localStorage.setItem('theme','dark');
      icon.className='bi bi-sun'; label.textContent='Light';
    }
  });
})();
</script>
</body>
</html>
